% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_openresult_inelan.R
\name{search_openresult_inelan}
\alias{search_openresult_inelan}
\title{Open a search result in 'ELAN'}
\usage{
search_openresult_inelan(
  x,
  s,
  resultNr,
  openOriginalEafFileIfAvailable = FALSE
)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{resultNr}{Integer; Number of the search result (row in the data frame \code{s@results}) to be opened.}

\item{openOriginalEafFileIfAvailable}{Logical; if \code{TRUE} the function will check if the original annotation file was an .eaf file and if it still exists in the original location. If so, the function will not create a temporary .eaf file but open the original file. Warning: The original .pfsx file (if it exists) will be overwritten.}
}
\description{
The function creates an temporary .eaf file and a .psfx file that locates the search hit.
These files will then be opened in ELAN.
To make this function work you need to have 'ELAN' installed on your computer and tell the act package where ELAN is located.
Therefore you need to set the path to the ELAN executable in the option 'act.path.elan' using \code{options(act.path.elan='PATHTOYOURELANEXECUTABLE')}.
}
\details{
WARNING: This function will overwrite existing .psfx files.

Credits: Thanks to Han Sloetjes for feedback on the structure of the temporary .pfsx files. He actually made the code work.
}
\examples{
library(act)

mysearch <- act::search_new(x=examplecorpus, pattern = "yo")

# You can only use this function if you have installed ELAN on our computer.
\dontrun{
options(act.path.elan='PATHTOYOURELANEXECUTABLE')
act::search_openresult_inelan(x=examplecorpus, s=mysearch, resultNr=1, TRUE)
}

}
