% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_rpraat.R
\name{export_rpraat}
\alias{export_rpraat}
\title{Export a transcript object to a 'rPraat' TextGrid object}
\usage{
export_rpraat(
  t,
  filterTierNames = NULL,
  filterSectionStartsec = NULL,
  filterSectionEndsec = NULL
)
}
\arguments{
\item{t}{Transcript object; transcript to be converted.}

\item{filterTierNames}{Vector of character strings; names of tiers to be included. If left unspecified, all tiers will be exported.}

\item{filterSectionStartsec}{Double; start of selection in seconds.}

\item{filterSectionEndsec}{Double; end of selection in seconds.}
}
\value{
rPraat TextGrid object
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_export} for exporting annotation files.
}
\details{
This function is to create compatibility with the \code{rPraat} package. 
It converts an act transcript to a rPraat TextGrid object.

Credits to Tomáš Bořil, the author of the rPraat package, for commenting on the exchange functions.
}
\examples{
library(act)

# Convert
rpraat.tg <- act::export_rpraat(t=examplecorpus@transcripts[[1]])

# Now you can use the object in the rPraat pachage.
# For instance you can plot the TextGrid
\dontrun{
	rPraat::tg.plot(rpraat.tg)
}
}
\seealso{
\code{import_rpraat}, \code{corpus_export}, \code{export_eaf}, \code{export_exb}, \code{export_printtranscript}, \code{export_srt}, \code{export_textgrid}
}
