% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snippets_cutlist.R
\name{snippets_cutlist}
\alias{snippets_cutlist}
\title{Create a cut list for 'FFmpeg'}
\usage{
snippets_cutlist(
  x = NULL,
  s = NULL,
  outputFolder = "",
  collection = "",
  outputFormat = "",
  mediaFileFilterInclude = "",
  returnCutlistForMacInsteadOfWindows = FALSE,
  contextBeforeSec = 0,
  contextAfterSec = 0,
  CodecCopy = TRUE,
  Panning = NA
)
}
\arguments{
\item{x}{Corpus object; Please note: all media paths for a transcript need to be given as a list in the corpus object in \code{corpus@transcripts[[ ]]@path.media} . You can use the respective media functions. .}

\item{s}{Search object.}

\item{outputFolder}{Character string; path to folder where files will be written.}

\item{collection}{Character string; name of collection that will be uses to create a sub folder in the output folder where all sequences will be stored}

\item{outputFormat}{Character string; file format of output, may be 'mp4', 'wav' or 'mp3'}

\item{mediaFileFilterInclude}{Character string; regular expression to use only some of the media files specified in corpus@transcripts[[ ]]@path.media )}

\item{returnCutlistForMacInsteadOfWindows}{Logical; if \code{TRUE} function will return a cut list for mac, if \code{FALSE} function will return a cutlist for windows.}

\item{contextBeforeSec}{Double; how much context before the search result will be included in seconds}

\item{contextAfterSec}{Double; how much context after the search result will be included in seconds}

\item{CodecCopy}{Logical; if \code{TRUE} FFMPEG will use the option *codec copy*.}

\item{Panning}{Integer; 0=leave audio as is (ch1&ch2) , 1=only channel 1 (ch1), 2=only channel 2 (ch2), 3=both channels separated (ch1&ch2), 4=all three versions (ch1&ch2, ch1, ch2). This setting will override the option made in 'act.ffmpeg.exportchannels.fromColumnName' .
#'}
}
\value{
Character string; the cut list.
}
\description{
This function creates a file that can be executed in the Terminal (Apple) or the Command Line Interface (Windows). 
The file contains commands to call 'FFmpeg' with all necessary information to cut media snippets for each search result.
}
\examples{
library(act)

# Please note: in the example corpus the transcripts are assigned media links.
# The actual media files are however not included in when installing the package.
# Please see the section 'examplecorpus' for isntruction how to download the
# media files.

# Search
mysearch <- act::search_new(examplecorpus, pattern="yo")

# Create cut list for Mac
cutlist <- act::snippets_cutlist (x=examplecorpus, s=mysearch)

# Create cut list for Windows
cutlist <- act::snippets_cutlist (x=examplecorpus,
                                         s=mysearch,
                                         returnCutlistForMacInsteadOfWindows=TRUE)

# Display cut list on screen, so you can copy&paste this into the Terminal or the CLI
cat(stringr::str_c(cutlist, sep="\n", collapse = "\n"))

# It is, however, more convenient to specify the argument 'outputFolder' in order to get
# the cut list as a (executable) file/batch list.
}
