% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_transcript_content.R,
%   R/search_transcript_fulltext.R
\name{search_transcript_content}
\alias{search_transcript_content}
\title{Search in original content of a single transcript}
\usage{
search_transcript_content(t, s, showProgress = TRUE)

search_transcript_content(t, s, showProgress = TRUE)
}
\arguments{
\item{t}{Transcript object; transcript to search in.}

\item{s}{Search object.}

\item{showProgress}{Logical; if \code{TRUE} progress bar will be shown.}
}
\value{
Data.frame; data frame with search results.
 
# @example inst/examples/search_transcript_content.R

Data.frame; data frame with search results.
}
\description{
Search in original content of a single transcript

Search in original content of a single transcript
}
\examples{
library(act)

# Search for the 1. Person Singular Pronoun in Spanish.
# Only create the search object without running the search.
mysearch <- act::search_new(x=examplecorpus, pattern= "yo", runSearch=FALSE)

# Run the search
df <- act::search_transcript_content(t=examplecorpus@transcripts[[3]],
                                     s=mysearch)
nrow(df)
}
