% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dbs.R
\name{dowload_acdc}
\alias{dowload_acdc}
\title{Download ACDC database from GitHub release}
\usage{
dowload_acdc(dest_dir, tag = NULL, token = Sys.getenv("GITHUB_PAT"))
}
\arguments{
\item{dest_dir}{Directory where the database should be saved.}

\item{tag}{Optional release tag. If NULL, uses latest release.}

\item{token}{Optional GitHub token. Defaults to \code{Sys.getenv("GITHUB_PAT")}.}
}
\value{
Invisibly returns the full path to the downloaded file.
}
\description{
Downloads the \code{acdc.db} SQLite database from the latest (or specified)
release on \code{jstbcs/acdc-database} to a given directory.
}
\examples{
\dontrun{
download_acdc(tempdir())
}
}
