% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_availability.R
\name{spatial_availability}
\alias{spatial_availability}
\title{Spatial availability}
\usage{
spatial_availability(
  travel_matrix,
  land_use_data,
  opportunity,
  travel_cost,
  demand,
  decay_function,
  alpha = 1,
  group_by = character(0),
  fill_missing_ids = TRUE
)
}
\arguments{
\item{travel_matrix}{A data frame. The travel matrix describing the costs
(i.e. travel time, distance, monetary cost, etc.) between the origins and
destinations in the study area. Must contain the columns \code{from_id}, \code{to_id}
and any others specified in \code{travel_cost}.}

\item{land_use_data}{A data frame. The distribution of opportunities within
the study area cells. Must contain the columns \code{id} and any others
specified in \code{opportunity}.}

\item{opportunity}{A string. The name of the column in \code{land_use_data}
with the number of opportunities/resources/services to be considered when
calculating accessibility levels.}

\item{travel_cost}{A string. The name of the column in \code{travel_matrix}
with the travel cost between origins and destinations.}

\item{demand}{A string. The name of the column in \code{land_use_data} with the
number of people in each origin that will be considered potential
competitors.}

\item{decay_function}{A \code{fuction} that converts travel cost into an
impedance factor used to weight opportunities. This function should take a
\code{numeric} vector and also return a \code{numeric} vector as output, with the
same length as the input. For convenience, the package currently includes
the following functions: \code{\link[=decay_binary]{decay_binary()}}, \code{\link[=decay_exponential]{decay_exponential()}},
\code{\link[=decay_power]{decay_power()}} and \code{\link[=decay_stepped]{decay_stepped()}}. See the documentation of each decay
function for more details.}

\item{alpha}{A \code{numeric}. A parameter used to modulate the effect of demand
by population. When less than 1, opportunities are allocated more rapidly
to smaller centers relative to larger ones; values higher than 1 achieve
the opposite effect.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{travel_matrix} columns that should be used to group the
accessibility estimates by. For example, if \code{travel_matrix} includes a
departure time column, that specifies the departure time of each entry in
the data frame, passing \code{"departure_time"} to this parameter results in
accessibility estimates grouped by origin and by departure time.}

\item{fill_missing_ids}{A \code{logical}. When calculating grouped accessibility
estimates (i.e. when \code{by_col} is not \code{NULL}), some combinations of groups
and origins may be missing. For example, if a single trip can depart from
origin \code{A} at 7:15am and reach destination \code{B} within 55 minutes, but no
trips departing from \code{A} at 7:30am can be completed at all, this second
combination will not be included in the output. When \code{TRUE} (the default),
the function identifies which combinations would be left out and fills
their respective accessibility values with 0, which incurs in a
performance penalty.}
}
\value{
A data frame containing the accessibility estimates for each
origin/destination (depending if \code{active} is \code{TRUE} or \code{FALSE}) in the
travel matrix.
}
\description{
Calculates spatial availability, an accessibility measured proposed by
\insertCite{soukhov2023introducing;textual}{accessibility} that takes into
account competition effects. The accessibility levels that result from using
this measure are proportional both to the demand in each origin and to the
travel cost it takes to reach the destinations.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# the example below is based on Soukhov et al. (2023) paper

travel_matrix <- data.table::data.table(
  from_id = rep(c("A", "B", "C"), each = 3),
  to_id = as.character(rep(1:3, 3)),
  travel_time = c(15, 30, 100, 30, 15, 100, 100, 100, 15)
)
land_use_data <- data.table::data.table(
  id = c("A", "B", "C", "1", "2", "3"),
  population = c(50000, 150000, 10000, 0, 0, 0),
  jobs = c(0, 0, 0, 100000, 100000, 10000)
)

df <- spatial_availability(
  travel_matrix,
  land_use_data,
  opportunity = "jobs",
  travel_cost = "travel_time",
  demand = "population",
  decay_function = decay_exponential(decay_value = 0.1)
)
df
\dontshow{\}) # examplesIf}
}
\references{
\insertAllCited{}
}
