% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_binary.R
\name{decay_binary}
\alias{decay_binary}
\title{Binary (a.k.a. step) decay function}
\usage{
decay_binary(cutoff)
}
\arguments{
\item{cutoff}{A \code{numeric} vector. The numbers indicating the travel cost
cutoffs.}
}
\value{
A \code{function} that takes a generic travel cost vector (\code{numeric}) as
an input and returns a \code{list} of weight vectors (a list of \code{numeric}
vectors, named after the arguments passed to the decay function).
}
\description{
Returns a binary weighting function (frequently used to calculate cumulative
opportunities measures) to be used inside accessibility calculating
functions.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
weighting_function <- decay_binary(cutoff = 30)

weighting_function(c(20, 35))

weighting_function <- decay_binary(cutoff = c(30, 45))

weighting_function(c(20, 35))
\dontshow{\}) # examplesIf}
}
\seealso{
Other decay functions: 
\code{\link{decay_exponential}()},
\code{\link{decay_linear}()},
\code{\link{decay_power}()},
\code{\link{decay_stepped}()}
}
\concept{decay functions}
