% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/submitImage.R
\name{submitImage}
\alias{submitImage}
\title{Submit Image}
\usage{
submitImage(file_path = NULL, taskId = "", pdfPassword = "")
}
\arguments{
\item{file_path}{Required; Path to the document}

\item{taskId}{Optional; Assigns image to the task ID specified. If an empty string is passed, a new task is created.}

\item{pdfPassword}{Optional; If the pdf is password protected, put the password here.}
}
\value{
Data frame with all the details of the submitted image: id (task id), registrationTime, statusChangeTime, status (Submitted, Queued, InProgress, Completed, ProcessingFailed, Deleted, NotEnoughCredits), filesCount (No. of files), credits
}
\description{
Adds image to the existing task or creates a new task for the uploaded image. The new task isn't processed till processDocument or processFields is called.
}
\examples{
\dontrun{
submitImage(file_path="/images/image1.png",taskId="task_id",pdfPassword="pdf_password")
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/submitImage/}
}

