% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_diameter.R
\name{add_radius}
\alias{add_radius}
\alias{add_radius,aRchi-method}
\title{Add the radius to a skeleton based on point distance to the skeleton}
\usage{
add_radius(aRchi, sec_length = 0.5, by_axis = TRUE, method = "median")

\S4method{add_radius}{aRchi}(aRchi, sec_length = 0.5, by_axis = TRUE, method = "median")
}
\arguments{
\item{aRchi}{an object of class aRchi containing at least a point cloud and a QSM.}

\item{sec_length}{numeric. The length of the section to compute the radius. See details.}

\item{by_axis}{logical. If \code{TRUE} the radius is calculated for each section within each axis, if \code{FALSE}
the radius is calculated within section for all axes simultaneously.}

\item{method}{character. The axis radius can be either the mean (\code{method = "mean"}) or the
median (\code{method = "median"}) distance to the skeleton.}
}
\value{
The aRchi file with an updated radius in the QSM slot.
}
\description{
Add the radius to a skeleton based on point distance to the skeleton
}
\details{
The point distance to skeleton is likely to vary considerably over short
         distances (e.g. at a branching point). Therefore, the radius is computed
         by averaging the point distance to the skeleton over sections of user defined
         length.
}
\examples{
\donttest{
# import a point cloud
tls=system.file("extdata","Tree_2_point_cloud.las",package = "aRchi")
tls = lidR::readLAS(tls)

aRchi = aRchi::build_aRchi()
aRchi = aRchi::add_pointcloud(aRchi,point_cloud = tls)

# build a skeleton from the point cloud
aRchi = aRchi::skeletonize_pc(aRchi)

# smooth the skeleton
aRchi = aRchi::smooth_skeleton(aRchi)

# add the diameter to the skeleton
aRchi = aRchi::add_radius(aRchi)

# plot the QSM
plot(aRchi,skeleton = FALSE,show_point_cloud = FALSE)
}
}
