% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_arbs.R
\name{get_arbs}
\alias{get_arbs}
\title{Find Arbitrage Opportunities}
\usage{
get_arbs(
  event = "https://www.oddschecker.com/football",
  in_play = FALSE,
  print_urls = FALSE,
  parallel = TRUE,
  debug = FALSE
)
}
\arguments{
\item{event}{A URL to a www.oddschecker.com sport homepage, given as a string.}

\item{in_play}{Logical. Should in-play arbitrage opportunities (arbs) also be returned?
These are not likely to be accurate arbs as some bookie's odds will not be up-to-date,
therefore default is \code{FALSE}.}

\item{print_urls}{Logical. Should the URL of the event(s) be printed to the console while
searching for arbitrage opportunities? Passed to \code{get_arb_single}.}

\item{parallel}{Logical. Should iterative calls to \code{get_arb_single} be made in
parallel.}

\item{debug}{Logical. If set to \code{TRUE}, \code{print_urls} will be turned on and
\code{parallel} will be turned off (so that URLs can be printed continuously).}
}
\value{
A list, with arbitrage information printed as series of dataframes.
}
\description{
Input a sport homepage URL as a string and return a list of arbitrage information.
This will also print dataframes with details of the arbitrage opportunities, including
the stake required for equal returns, the value of said equal returns, along with the
relevant bookie for each outcome.
}
\details{
The workhorse function, clearly, is \code{get_arb_single}, however \code{get_arbs}
implements it iteratively, after scraping and cleaning the required inputs for each
distinct call to \code{get_arb_single}. This includes finding all the sub-URLs
of the homepage. A progress bar is also used as the runtime is significant.
}
