% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Achilles.R
\name{Achilles}
\alias{Achilles}
\alias{A052486}
\title{Achilles numbers}
\usage{
Achilles(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A052486}{A052486}, an \emph{Achilles} number is a number
that is \emph{powerful} but \emph{not perfect}. First 6 Achilles numbers are 72, 108, 200, 288, 392, 432.
}
\examples{
## generate first 3 Achilles numbers
first3 = Achilles(3)

## print without trailing 0's.
print(first3, drop0trailing = TRUE)

}
