% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{setx1}
\alias{setx1}
\title{Setting Explanatory Variable Values for First Differences}
\usage{
setx1(obj, fn = NULL, data = NULL, cond = FALSE, ...)
}
\arguments{
\item{obj}{output object from \code{\link{zelig}}}

\item{fn}{a list of functions to apply to the data frame}

\item{data}{a new data frame used to set the values of
explanatory variables. If \code{data = NULL} (the default), the
data frame called in \code{\link{zelig}} is used}

\item{cond}{a logical value indicating whether unconditional
(default) or conditional (choose \code{cond = TRUE}) prediction
should be performed. If you choose \code{cond = TRUE}, \code{setx1}
will coerce \code{fn = NULL} and ignore the additional arguments in
\code{\dots}. If \code{cond = TRUE} and \code{data = NULL},
\code{setx1} will prompt you for a data frame.}

\item{...}{user-defined values of specific variables for overwriting the
default values set by the function \code{fn}. For example, adding
\code{var1 = mean(data\$var1)} or \code{x1 = 12} explicitly sets the value
of \code{x1} to 12. In addition, you may specify one explanatory variable
as a range of values, creating one observation for every unique value in
the range of values}
}
\value{
The output is returned in a field to the Zelig object. For
  unconditional prediction, \code{x.out} is a model matrix based
  on the specified values for the explanatory variables. For multiple
  analyses (i.e., when choosing the \code{by} option in \code{\link{zelig}},
  \code{setx1} returns the selected values calculated over the entire
  data frame. If you wish to calculate values over just one subset of
  the data frame, the 5th subset for example, you may use:
  \code{x.out <- setx(z.out[[5]])}
}
\description{
This documentation describes the \code{setx1} Zelig 4 compatibility wrapper
function. The wrapper is primarily useful for setting fitted values
for creating first differences in piped workflows.
}
\examples{
library(dplyr) # contains pipe operator \%>\%
data(turnout)

# plot first differences
zelig(Fertility ~ Education, data = swiss, model = 'ls') \%>\%
      setx(z4, Education = 10) \%>\%
      setx1(z4, Education = 30) \%>\%
      sim() \%>\%
      plot()

}
\seealso{
The full Zelig manual may be accessed online at
  \url{http://docs.zeligproject.org/en/latest/}
}
\author{
Christopher Gandrud, Matt Owen, Olivia Lau, Kosuke Imai
}
\keyword{file}
