% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{data_playlist_request}
\alias{data_playlist_request}
\title{Playlist Data Requests - YouTube Data API}
\usage{
data_playlist_request(
  part = NULL,
  channelId = NULL,
  hl = NULL,
  id = NULL,
  maxResults = 5,
  mine = NULL,
  onBehalfOfContentOwner = NULL,
  onBehalfOfContentOwnerChannel = NULL,
  pageToken = NULL,
  token = getOption("YouTube_Token")
)
}
\arguments{
\item{part}{Required. String.}

\item{channelId}{String.}

\item{hl}{String.}

\item{id}{String.}

\item{maxResults}{Integer.}

\item{mine}{String}

\item{onBehalfOfContentOwner}{String.}

\item{onBehalfOfContentOwnerChannel}{String.}

\item{pageToken}{String.}

\item{token}{Required.}
}
\value{
data.frame
}
\description{
This is a function to make API calls to the YouTube Data API for playlist specific data.
While it can be called directly, it is primarily intended to help get lists of videos within
a playlist. For more in-depth use of the Data API, please refer to \code{tuber}. For
more details on the following arguments, please refer to
\url{https://developers.google.com/youtube/v3/docs/playlists/list}
}
\examples{
\dontrun{
data_playlist_request(part = "contentDetails",
                      id = "PLA2387dsgkhfs9832hjkhuihsASDF",
                      mine = "true")
}
}
