% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xsoil.R
\name{xsoil}
\alias{xsoil}
\title{xsoil}
\usage{
xsoil(ximages_output, localPath = tempdir())
}
\arguments{
\item{ximages_output}{A \code{data.frame} output from \code{ximages} function.}

\item{localPath}{Path to store the images. Default: \code{tempdir()}}
}
\value{
It returns a \code{data.frame} object and exports a \code{.csv}
file with the soil data. The \code{.csv} file will be save under
a new directory (\code{POLARISOut}) in the user's machine.
}
\description{
Extracting soil data from downloaded images.
}
\details{
This function must be executed after downloading the images,
because it depends on the output from the \code{ximages} function.
}
\examples{
\dontrun{
df_test <- exkansas
df_ximages <- ximages(locations = df_test,
                      variables = c('clay'),
                      statistics = c('mean'),
                      layersdepths = c('0_5'))
df_xsoil <- xsoil(ximages_output = df_ximages)
}
}
\seealso{
\code{\link[XPolaris]{xplot}},\code{\link[XPolaris]{ximages}}
}
