/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.DataFormatOnlyCellStyle;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.HCellStyle;
import com.miraisolutions.xlconnect.SSCellStyle;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.XCellStyle;
import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.data.DefaultColumnBuilder;
import com.miraisolutions.xlconnect.data.FastColumnBuilder;
import com.miraisolutions.xlconnect.data.ReadStrategy;
import com.miraisolutions.xlconnect.utils.DateTimeFormatter;
import com.miraisolutions.xlconnect.utils.RPOSIXDateTimeFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class Workbook
extends Common {
    private static final String HEADER = "Header";
    private static final String COLUMN = "Column";
    private static final String SEP = ".";
    private static final String HEADER_STYLE = "XLConnect.Header";
    private static final String NUMERIC_STYLE = "XLConnect.Numeric";
    private static final String STRING_STYLE = "XLConnect.String";
    private static final String BOOLEAN_STYLE = "XLConnect.Boolean";
    private static final String DATETIME_STYLE = "XLConnect.DateTime";
    public static final DateTimeFormatter dateTimeFormatter = new RPOSIXDateTimeFormatter();
    private final org.apache.poi.ss.usermodel.Workbook workbook;
    private File excelFile;
    private StyleAction styleAction = StyleAction.XLCONNECT;
    private String styleNamePrefix = null;
    private Object[] missingValue = new Object[]{null};
    private final Map<String, CellStyle> defaultStyles = new HashMap<String, CellStyle>(5);
    private final Map<DataType, CellStyle> dataTypeStyles = new EnumMap<DataType, CellStyle>(DataType.class);
    private final Map<DataType, String> dataFormatMap = new EnumMap<DataType, String>(DataType.class);
    private ErrorBehavior onErrorCell = ErrorBehavior.WARN;

    private Workbook(InputStream in) throws IOException, InvalidFormatException {
        this.workbook = WorkbookFactory.create((InputStream)in);
        this.excelFile = null;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private Workbook(File excelFile) throws FileNotFoundException, IOException, InvalidFormatException {
        this(new FileInputStream(excelFile));
        this.excelFile = excelFile;
    }

    private Workbook(File excelFile, SpreadsheetVersion version) {
        switch (version) {
            case EXCEL97: {
                this.workbook = new HSSFWorkbook();
                break;
            }
            case EXCEL2007: {
                this.workbook = new XSSFWorkbook();
                break;
            }
            default: {
                throw new IllegalArgumentException("Spreadsheet version not supported!");
            }
        }
        this.excelFile = excelFile;
        this.initDefaultDataFormats();
        this.initDefaultStyles();
    }

    private void initDefaultDataFormats() {
        this.dataFormatMap.put(DataType.Boolean, "General");
        this.dataFormatMap.put(DataType.DateTime, "mm/dd/yyyy hh:mm:ss");
        this.dataFormatMap.put(DataType.Numeric, "General");
        this.dataFormatMap.put(DataType.String, "General");
    }

    private CellStyle initGeneralStyle(String name, DataType type) {
        CellStyle style = this.getCellStyle(name);
        if (style == null) {
            style = this.createCellStyle(name);
            if (type == null) {
                style.setDataFormat("General");
            } else {
                style.setDataFormat(this.dataFormatMap.get((Object)type));
            }
            style.setWrapText(true);
        }
        return style;
    }

    private CellStyle initGeneralStyle(String name) {
        return this.initGeneralStyle(name, null);
    }

    private void initDefaultStyles() {
        CellStyle headerStyle = this.getCellStyle(HEADER_STYLE);
        if (headerStyle == null) {
            headerStyle = this.initGeneralStyle(HEADER_STYLE);
            headerStyle.setFillPattern((short)1);
            headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        }
        CellStyle stringStyle = this.initGeneralStyle(STRING_STYLE);
        this.dataTypeStyles.put(DataType.String, stringStyle);
        CellStyle numericStyle = this.initGeneralStyle(NUMERIC_STYLE);
        this.dataTypeStyles.put(DataType.Numeric, numericStyle);
        CellStyle booleanStyle = this.initGeneralStyle(BOOLEAN_STYLE);
        this.dataTypeStyles.put(DataType.Boolean, booleanStyle);
        CellStyle dateStyle = this.getCellStyle(DATETIME_STYLE);
        if (dateStyle == null) {
            dateStyle = this.createCellStyle(DATETIME_STYLE);
            dateStyle.setDataFormat(this.dataFormatMap.get((Object)DataType.DateTime));
            dateStyle.setWrapText(true);
        }
        this.dataTypeStyles.put(DataType.DateTime, dateStyle);
        this.defaultStyles.put(HEADER_STYLE, headerStyle);
        this.defaultStyles.put(STRING_STYLE, stringStyle);
        this.defaultStyles.put(NUMERIC_STYLE, numericStyle);
        this.defaultStyles.put(BOOLEAN_STYLE, booleanStyle);
        this.defaultStyles.put(DATETIME_STYLE, dateStyle);
    }

    public void setCellStyleForDataType(DataType type, CellStyle cs) {
        this.dataTypeStyles.put(type, cs);
    }

    public CellStyle getCellStyleForDataType(DataType type) {
        return this.dataTypeStyles.get((Object)type);
    }

    public void setDataFormat(DataType type, String format) {
        this.dataFormatMap.put(type, format);
    }

    public String getDataFormat(DataType type) {
        return this.dataFormatMap.get((Object)type);
    }

    public StyleAction getStyleAction() {
        return this.styleAction;
    }

    public void setStyleAction(StyleAction styleAction) {
        this.styleAction = styleAction;
    }

    public String getStyleNamePrefix() {
        return this.styleNamePrefix;
    }

    public void setStyleNamePrefix(String styleNamePrefix) {
        this.styleNamePrefix = styleNamePrefix;
    }

    public String[] getSheets() {
        int count = this.workbook.getNumberOfSheets();
        String[] sheetNames = new String[count];
        for (int i = 0; i < count; ++i) {
            sheetNames[i] = this.workbook.getSheetName(i);
        }
        return sheetNames;
    }

    public int getSheetPos(String sheetName) {
        return this.workbook.getSheetIndex(sheetName);
    }

    public void setSheetPos(String sheetName, int pos) {
        this.workbook.setSheetOrder(sheetName, pos);
    }

    public String[] getDefinedNames(boolean validOnly) {
        int count = this.workbook.getNumberOfNames();
        ArrayList<String> nameNames = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Name namedRegion = this.workbook.getNameAt(i);
            if (validOnly && !this.isValidNamedRegion(namedRegion)) continue;
            nameNames.add(namedRegion.getNameName());
        }
        return nameNames.toArray(new String[nameNames.size()]);
    }

    private boolean isValidNamedRegion(Name region) {
        return !region.isDeleted() && this.hasValidWorkSheet(region);
    }

    private boolean hasValidWorkSheet(Name region) {
        return region.getSheetName() != null && !"".equals(region.getSheetName());
    }

    public boolean existsSheet(String name) {
        return this.workbook.getSheet(name) != null;
    }

    public boolean existsName(String name) {
        return this.workbook.getName(name) != null;
    }

    public void createSheet(String name) {
        if (name.length() > 31) {
            throw new IllegalArgumentException("Sheet names are not allowed to contain more than 31 characters!");
        }
        if (this.workbook.getSheetIndex(name) < 0) {
            this.workbook.createSheet(name);
        }
    }

    public void removeSheet(int sheetIndex) {
        if (sheetIndex > -1 && sheetIndex < this.workbook.getNumberOfSheets()) {
            this.setAlternativeActiveSheet(sheetIndex);
            this.workbook.removeSheetAt(sheetIndex);
        }
    }

    public void removeSheet(String name) {
        this.removeSheet(this.workbook.getSheetIndex(name));
    }

    public void renameSheet(int sheetIndex, String newName) {
        this.renameSheet(this.workbook.getSheetName(sheetIndex), newName);
    }

    public void renameSheet(String name, String newName) {
        this.workbook.setSheetName(this.workbook.getSheetIndex(name), newName);
    }

    public void cloneSheet(int index, String newName) {
        this.cloneSheet(this.workbook.getSheetName(index), newName);
    }

    public void cloneSheet(String name, String newName) {
        Sheet sheet = this.workbook.cloneSheet(this.workbook.getSheetIndex(name));
        this.workbook.setSheetName(this.workbook.getSheetIndex(sheet), newName);
    }

    public void createName(String name, String formula, boolean overwrite) {
        if (this.existsName(name)) {
            if (overwrite) {
                this.removeName(name);
            } else {
                throw new IllegalArgumentException("Specified name '" + name + "' already exists!");
            }
        }
        Name cname = this.workbook.createName();
        try {
            cname.setNameName(name);
            cname.setRefersToFormula(formula);
        }
        catch (Exception e) {
            String dummyNameName = "XLConnectDummyName";
            cname.setNameName(dummyNameName);
            this.removeName(dummyNameName);
            throw new IllegalArgumentException(e);
        }
    }

    public void removeName(String name) {
        Name cname = this.workbook.getName(name);
        if (cname != null) {
            this.workbook.removeName(name);
        }
    }

    public String getReferenceFormula(String name) {
        return this.getName(name).getRefersToFormula();
    }

    public int[] getReferenceCoordinates(String name) {
        return this.getReferenceCoordinatesForName(name);
    }

    public int[] getReferenceCoordinatesForName(String name) {
        Name cname = this.getName(name);
        AreaReference aref = new AreaReference(cname.getRefersToFormula());
        CellReference first = aref.getFirstCell();
        CellReference last = aref.getLastCell();
        int top = first.getRow();
        int bottom = last.getRow();
        short left = first.getCol();
        short right = last.getCol();
        return new int[]{top, left, bottom, right};
    }

    public String[] getTables(int sheetIndex) {
        if (this.isXSSF()) {
            XSSFSheet s = (XSSFSheet)this.getSheet(sheetIndex);
            String[] tables = new String[s.getTables().size()];
            int i = 0;
            Iterator it = s.getTables().iterator();
            while (it.hasNext()) {
                tables[i++] = ((XSSFTable)it.next()).getName();
            }
            return tables;
        }
        return new String[0];
    }

    public String[] getTables(String sheetName) {
        return this.getTables(this.workbook.getSheetIndex(sheetName));
    }

    public int[] getReferenceCoordinatesForTable(int sheetIndex, String tableName) {
        if (!this.isXSSF()) {
            throw new IllegalArgumentException("Tables are not supported with this file format");
        }
        XSSFSheet s = (XSSFSheet)this.getSheet(sheetIndex);
        for (XSSFTable t : s.getTables()) {
            if (!tableName.equals(t.getName())) continue;
            CellReference start = t.getStartCellReference();
            CellReference end = t.getEndCellReference();
            int top = start.getRow();
            int bottom = end.getRow();
            short left = start.getCol();
            short right = end.getCol();
            return new int[]{top, left, bottom, right};
        }
        throw new IllegalArgumentException("Could not find table '" + tableName + "'!");
    }

    public int[] getReferenceCoordinatesForTable(String sheetName, String tableName) {
        return this.getReferenceCoordinatesForTable(this.workbook.getSheetIndex(sheetName), tableName);
    }

    private void writeData(DataFrame data, Sheet sheet, int startRow, int startCol, boolean header) {
        int i;
        Map<String, CellStyle> styles = this.getStyles(data, sheet, startRow, startCol);
        int rowIndex = startRow;
        int colIndex = startCol;
        if (header && data.hasColumnHeader()) {
            for (i = 0; i < data.columns(); ++i) {
                Cell cell = this.getCell(sheet, rowIndex, colIndex + i);
                cell.setCellValue(data.getColumnName(i));
                cell.setCellType(1);
                this.setCellStyle(cell, styles.get(HEADER + i));
            }
            ++rowIndex;
        }
        for (i = 0; i < data.columns(); ++i) {
            CellStyle cs = styles.get(COLUMN + i);
            Column col = data.getColumn(i);
            switch (data.getColumnType(i)) {
                case Numeric: {
                    double[] doubleValues = col.getNumericData();
                    for (int j = 0; j < data.rows(); ++j) {
                        Cell cell = this.getCell(sheet, rowIndex + j, colIndex);
                        if (col.isMissing(j)) {
                            this.setMissing(cell);
                            continue;
                        }
                        if (Double.isInfinite(doubleValues[j])) {
                            cell.setCellType(5);
                            cell.setCellErrorValue(FormulaError.NA.getCode());
                        } else {
                            cell.setCellValue(doubleValues[j]);
                            cell.setCellType(0);
                        }
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                case String: {
                    String[] stringValues = col.getStringData();
                    for (int j = 0; j < data.rows(); ++j) {
                        Cell cell = this.getCell(sheet, rowIndex + j, colIndex);
                        if (col.isMissing(j)) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(stringValues[j]);
                        cell.setCellType(1);
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                case Boolean: {
                    boolean[] booleanValues = col.getBooleanData();
                    for (int j = 0; j < data.rows(); ++j) {
                        Cell cell = this.getCell(sheet, rowIndex + j, colIndex);
                        if (col.isMissing(j)) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(booleanValues[j]);
                        cell.setCellType(4);
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                case DateTime: {
                    Date[] dateValues = col.getDateTimeData();
                    for (int j = 0; j < data.rows(); ++j) {
                        Cell cell = this.getCell(sheet, rowIndex + j, colIndex);
                        if (col.isMissing(j)) {
                            this.setMissing(cell);
                            continue;
                        }
                        cell.setCellValue(dateValues[j]);
                        cell.setCellType(0);
                        this.setCellStyle(cell, cs);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type detected!");
                }
            }
            ++colIndex;
        }
        if (this.isHSSF()) {
            ((HSSFSheet)sheet).setForceFormulaRecalculation(true);
        }
    }

    private DataFrame readData(Sheet sheet, int startRow, int startCol, int nrows, int ncols, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset) {
        ColumnBuilder cb;
        int[] colset;
        DataFrame data = new DataFrame();
        FormulaEvaluator evaluator = null;
        if (!takeCached) {
            evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
            evaluator.clearAllCachedResultValues();
        }
        if (subset == null) {
            colset = new int[ncols];
            for (int i = 0; i < ncols; ++i) {
                colset[i] = i;
            }
        } else {
            colset = subset;
        }
        switch (readStrategy) {
            case DEFAULT: {
                cb = new DefaultColumnBuilder(nrows, forceConversion, evaluator, this.onErrorCell, this.missingValue, dateTimeFormat);
                break;
            }
            case FAST: {
                cb = new FastColumnBuilder(nrows, forceConversion, evaluator, this.onErrorCell, dateTimeFormat);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown read strategy!");
            }
        }
        for (int col : colset) {
            int row;
            Cell cell;
            int colIndex = startCol + col;
            String columnHeader = null;
            if (header && (cell = this.getCell(sheet, startRow, colIndex, false)) != null) {
                if (!takeCached) {
                    CellValue cv = evaluator.evaluate(cell);
                    if (cv != null) {
                        columnHeader = cv.getStringValue();
                    }
                } else {
                    columnHeader = cell.getStringCellValue();
                }
            }
            if (columnHeader == null) {
                columnHeader = "Col" + (col + 1);
            }
            cb.clear();
            int n = row = header ? 1 : 0;
            while (row < nrows) {
                int rowIndex = startRow + row;
                Row r = sheet.getRow(rowIndex);
                Cell cell2 = r == null ? null : r.getCell(colIndex);
                cb.addCell(cell2);
                ++row;
            }
            DataType columnType = colTypes != null && colTypes.length > 0 ? colTypes[col % colTypes.length] : cb.determineColumnType();
            switch (columnType) {
                case Boolean: {
                    data.addColumn(columnHeader, cb.buildBooleanColumn());
                    break;
                }
                case DateTime: {
                    data.addColumn(columnHeader, cb.buildDateTimeColumn());
                    break;
                }
                case Numeric: {
                    data.addColumn(columnHeader, cb.buildNumericColumn());
                    break;
                }
                case String: {
                    data.addColumn(columnHeader, cb.buildStringColumn());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown data type detected!");
                }
            }
            for (String w : cb.retrieveWarnings()) {
                this.addWarning(w);
            }
        }
        return data;
    }

    public void onErrorCell(ErrorBehavior eb) {
        this.onErrorCell = eb;
    }

    public void writeNamedRegion(DataFrame data, String name, boolean header) {
        Name cname = this.getName(name);
        this.checkName(cname);
        Sheet sheet = this.workbook.getSheet(cname.getSheetName());
        AreaReference aref = new AreaReference(cname.getRefersToFormula());
        CellReference topLeft = aref.getFirstCell();
        int bottomRightRow = Math.max(topLeft.getRow() + data.rows() - 1, topLeft.getRow());
        if (header) {
            ++bottomRightRow;
        }
        int bottomRightCol = Math.max(topLeft.getCol() + data.columns() - 1, topLeft.getCol());
        CellReference bottomRight = new CellReference(sheet.getSheetName(), bottomRightRow, bottomRightCol, true, true);
        aref = new AreaReference(topLeft, bottomRight);
        cname.setRefersToFormula(aref.formatAsString());
        this.writeData(data, sheet, topLeft.getRow(), topLeft.getCol(), header);
    }

    public DataFrame readNamedRegion(String name, boolean header) {
        return this.readNamedRegion(name, header, ReadStrategy.DEFAULT, null, false, "", false, null);
    }

    public DataFrame readNamedRegion(String name, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset) {
        Name cname = this.getName(name);
        this.checkName(cname);
        Sheet sheet = this.workbook.getSheet(cname.getSheetName());
        AreaReference aref = new AreaReference(cname.getRefersToFormula());
        CellReference topLeft = aref.getFirstCell();
        CellReference bottomRight = aref.getLastCell();
        int nrows = bottomRight.getRow() - topLeft.getRow() + 1;
        int ncols = bottomRight.getCol() - topLeft.getCol() + 1;
        return this.readData(sheet, topLeft.getRow(), topLeft.getCol(), nrows, ncols, header, readStrategy, colTypes, forceConversion, dateTimeFormat, takeCached, subset);
    }

    public DataFrame readTable(int worksheetIndex, String tableName, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset) {
        if (!this.isXSSF()) {
            throw new IllegalArgumentException("Tables are not supported with this file format!");
        }
        XSSFSheet s = (XSSFSheet)this.getSheet(worksheetIndex);
        int[] coords = this.getReferenceCoordinatesForTable(worksheetIndex, tableName);
        int nrows = coords[2] - coords[0] + 1;
        int ncols = coords[3] - coords[1] + 1;
        return this.readData((Sheet)s, coords[0], coords[1], nrows, ncols, header, readStrategy, colTypes, forceConversion, dateTimeFormat, takeCached, subset);
    }

    public DataFrame readTable(String worksheetName, String tableName, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset) {
        return this.readTable(this.workbook.getSheetIndex(worksheetName), tableName, header, readStrategy, colTypes, forceConversion, dateTimeFormat, takeCached, subset);
    }

    public void writeWorksheet(DataFrame data, int worksheetIndex, int startRow, int startCol, boolean header) {
        Sheet sheet = this.workbook.getSheetAt(worksheetIndex);
        this.writeData(data, sheet, startRow, startCol, header);
    }

    public void writeWorksheet(DataFrame data, String worksheetName, int startRow, int startCol, boolean header) {
        this.writeWorksheet(data, this.workbook.getSheetIndex(worksheetName), startRow, startCol, header);
    }

    public void writeWorksheet(DataFrame data, int worksheetIndex, boolean header) {
        this.writeWorksheet(data, worksheetIndex, 0, 0, header);
    }

    public void writeWorksheet(DataFrame data, String worksheetName, boolean header) {
        this.writeWorksheet(data, worksheetName, 0, 0, header);
    }

    public DataFrame readWorksheet(int worksheetIndex, int startRow, int startCol, int endRow, int endCol, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, boolean autofitRow, boolean autofitCol) {
        int ncols;
        Sheet sheet = this.workbook.getSheetAt(worksheetIndex);
        int[] boundingBox = this.getBoundingBox(worksheetIndex, startRow, startCol, endRow, endCol, autofitRow, autofitCol);
        startRow = boundingBox[0];
        startCol = boundingBox[1];
        endRow = boundingBox[2];
        endCol = boundingBox[3];
        int nrows = startRow < 0 ? 0 : endRow - startRow + 1;
        int n = ncols = startCol < 0 ? 0 : endCol - startCol + 1;
        if (nrows == 0 || ncols == 0) {
            this.addWarning("Data frame contains " + nrows + " rows and " + ncols + " columns!");
        }
        return this.readData(sheet, startRow, startCol, nrows, ncols, header, readStrategy, colTypes, forceConversion, dateTimeFormat, takeCached, subset);
    }

    public DataFrame readWorksheet(int worksheetIndex, int startRow, int startCol, int endRow, int endCol, boolean header) {
        return this.readWorksheet(worksheetIndex, startRow, startCol, endRow, endCol, header, ReadStrategy.DEFAULT, null, false, "", false, null, true, true);
    }

    public DataFrame readWorksheet(int worksheetIndex, int startRow, int startCol, int endRow, int endCol, boolean header, boolean autofitRow, boolean autofitCol) {
        return this.readWorksheet(worksheetIndex, startRow, startCol, endRow, endCol, header, ReadStrategy.DEFAULT, null, false, "", false, null, autofitRow, autofitCol);
    }

    public DataFrame readWorksheet(int worksheetIndex, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat) {
        return this.readWorksheet(worksheetIndex, -1, -1, -1, -1, header, readStrategy, colTypes, forceConversion, dateTimeFormat, false, null, true, true);
    }

    public DataFrame readWorksheet(int worksheetIndex, boolean header) {
        return this.readWorksheet(worksheetIndex, header, ReadStrategy.DEFAULT, null, false, "");
    }

    public DataFrame readWorksheet(String worksheetName, int startRow, int startCol, int endRow, int endCol, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, boolean autofitRow, boolean autofitCol) {
        return this.readWorksheet(this.workbook.getSheetIndex(worksheetName), startRow, startCol, endRow, endCol, header, readStrategy, colTypes, forceConversion, dateTimeFormat, takeCached, subset, autofitRow, autofitCol);
    }

    public DataFrame readWorksheet(String worksheetName, int startRow, int startCol, int endRow, int endCol, boolean header) {
        return this.readWorksheet(worksheetName, startRow, startCol, endRow, endCol, header, ReadStrategy.DEFAULT, null, false, "", false, null, true, true);
    }

    public DataFrame readWorksheet(String worksheetName, int startRow, int startCol, int endRow, int endCol, boolean header, boolean autofitRow, boolean autofitCol) {
        return this.readWorksheet(worksheetName, startRow, startCol, endRow, endCol, header, ReadStrategy.DEFAULT, null, false, "", false, null, autofitRow, autofitCol);
    }

    public DataFrame readWorksheet(String worksheetName, boolean header, ReadStrategy readStrategy, DataType[] colTypes, boolean forceConversion, String dateTimeFormat) {
        return this.readWorksheet(worksheetName, -1, -1, -1, -1, header, readStrategy, colTypes, forceConversion, dateTimeFormat, false, null, true, true);
    }

    public DataFrame readWorksheet(String worksheetName, boolean header) {
        return this.readWorksheet(worksheetName, header, ReadStrategy.DEFAULT, null, false, "");
    }

    public void addImage(File imageFile, String name, boolean originalSize) throws FileNotFoundException, IOException {
        Object drawing;
        int imageType;
        Name cname = this.getName(name);
        Sheet sheet = this.workbook.getSheet(cname.getSheetName());
        AreaReference aref = new AreaReference(cname.getRefersToFormula());
        CellReference topLeft = aref.getFirstCell();
        CellReference bottomRight = aref.getLastCell();
        String filename = imageFile.getName().toLowerCase();
        if (filename.endsWith("jpg") || filename.endsWith("jpeg")) {
            imageType = 5;
        } else if (filename.endsWith("png")) {
            imageType = 6;
        } else if (filename.endsWith("wmf")) {
            imageType = 3;
        } else if (filename.endsWith("emf")) {
            imageType = 2;
        } else if (filename.endsWith("bmp") || filename.endsWith("dib")) {
            imageType = 7;
        } else if (filename.endsWith("pict") || filename.endsWith("pct") || filename.endsWith("pic")) {
            imageType = 4;
        } else {
            throw new IllegalArgumentException("Image type \"" + filename.substring(filename.lastIndexOf(46) + 1) + "\" not supported!");
        }
        FileInputStream is = new FileInputStream(imageFile);
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        int imageIndex = this.workbook.addPicture(bytes, imageType);
        ((InputStream)is).close();
        if (this.isHSSF()) {
            drawing = ((HSSFSheet)sheet).getDrawingPatriarch();
            if (drawing == null) {
                drawing = sheet.createDrawingPatriarch();
            }
        } else {
            drawing = this.isXSSF() ? ((XSSFSheet)sheet).createDrawingPatriarch() : sheet.createDrawingPatriarch();
        }
        CreationHelper helper = this.workbook.getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setRow1(topLeft.getRow());
        anchor.setCol1((int)topLeft.getCol());
        anchor.setRow2(bottomRight.getRow() + 1);
        anchor.setCol2(bottomRight.getCol() + 1);
        anchor.setAnchorType(3);
        Picture picture = drawing.createPicture(anchor, imageIndex);
        if (originalSize) {
            picture.resize();
        }
    }

    public void addImage(String filename, String name, boolean originalSize) throws FileNotFoundException, IOException {
        this.addImage(new File(filename), name, originalSize);
    }

    public CellStyle createCellStyle(String name) {
        if (this.getCellStyle(name) == null) {
            if (this.isHSSF()) {
                return HCellStyle.create((HSSFWorkbook)this.workbook, name);
            }
            if (this.isXSSF()) {
                return XCellStyle.create((XSSFWorkbook)this.workbook, name);
            }
            return null;
        }
        throw new IllegalArgumentException("Cell style with name '" + name + "' already exists!");
    }

    public CellStyle createCellStyle() {
        return this.createCellStyle(null);
    }

    public int getActiveSheetIndex() {
        if (this.workbook.getNumberOfSheets() < 1) {
            return -1;
        }
        return this.workbook.getActiveSheetIndex();
    }

    public String getActiveSheetName() {
        if (this.workbook.getNumberOfSheets() < 1) {
            return null;
        }
        return this.workbook.getSheetName(this.workbook.getActiveSheetIndex());
    }

    public void setActiveSheet(int sheetIndex) {
        this.workbook.setActiveSheet(sheetIndex);
    }

    public void setActiveSheet(String sheetName) {
        int sheetIndex = this.workbook.getSheetIndex(sheetName);
        this.setActiveSheet(sheetIndex);
    }

    public void hideSheet(int sheetIndex, boolean veryHidden) {
        this.setAlternativeActiveSheet(sheetIndex);
        this.workbook.setSheetHidden(sheetIndex, veryHidden ? 2 : 1);
    }

    public void hideSheet(String sheetName, boolean veryHidden) {
        this.hideSheet(this.workbook.getSheetIndex(sheetName), veryHidden);
    }

    public void unhideSheet(int sheetIndex) {
        this.workbook.setSheetHidden(sheetIndex, 0);
    }

    public void unhideSheet(String sheetName) {
        this.unhideSheet(this.workbook.getSheetIndex(sheetName));
    }

    public boolean isSheetHidden(int sheetIndex) {
        return this.workbook.isSheetHidden(sheetIndex);
    }

    public boolean isSheetHidden(String sheetName) {
        return this.isSheetHidden(this.workbook.getSheetIndex(sheetName));
    }

    public boolean isSheetVeryHidden(int sheetIndex) {
        return this.workbook.isSheetVeryHidden(sheetIndex);
    }

    public boolean isSheetVeryHidden(String sheetName) {
        return this.isSheetVeryHidden(this.workbook.getSheetIndex(sheetName));
    }

    public void setColumnWidth(int sheetIndex, int columnIndex, int width) {
        Sheet sheet = this.getSheet(sheetIndex);
        if (width >= 0) {
            sheet.setColumnWidth(columnIndex, width);
        } else if (width == -1) {
            sheet.autoSizeColumn(columnIndex);
        } else {
            sheet.setColumnWidth(columnIndex, sheet.getDefaultColumnWidth() * 256);
        }
    }

    public void setColumnWidth(String sheetName, int columnIndex, int width) {
        this.setColumnWidth(this.workbook.getSheetIndex(sheetName), columnIndex, width);
    }

    public void setRowHeight(int sheetIndex, int rowIndex, float height) {
        Sheet sheet = this.getSheet(sheetIndex);
        Row r = sheet.getRow(rowIndex);
        if (r == null) {
            r = this.getSheet(sheetIndex).createRow(rowIndex);
        }
        if (height >= 0.0f) {
            r.setHeightInPoints(height);
        } else {
            r.setHeightInPoints(sheet.getDefaultRowHeightInPoints());
        }
    }

    public void setRowHeight(String sheetName, int rowIndex, float height) {
        this.setRowHeight(this.workbook.getSheetIndex(sheetName), rowIndex, height);
    }

    public void save(File f) throws FileNotFoundException, IOException {
        this.excelFile = f;
        FileOutputStream fos = new FileOutputStream(f, false);
        this.workbook.write((OutputStream)fos);
        fos.close();
    }

    public void save(String file) throws FileNotFoundException, IOException {
        this.save(new File(file));
    }

    public void save() throws FileNotFoundException, IOException {
        this.save(this.excelFile);
    }

    Name getName(String name) {
        Name cname = this.workbook.getName(name);
        if (cname != null) {
            return cname;
        }
        throw new IllegalArgumentException("Name '" + name + "' does not exist!");
    }

    private boolean isValidReference(String reference) {
        return reference != null && !reference.startsWith("#REF!") && !reference.startsWith("#NULL!");
    }

    private void checkName(Name name) {
        if (!this.isValidReference(name.getRefersToFormula())) {
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' has invalid reference!");
        }
        if (!this.existsSheet(name.getSheetName())) {
            throw new IllegalArgumentException("Name '" + name.getNameName() + "' does not refer to a valid sheet!");
        }
    }

    private boolean isXSSF() {
        return this.workbook instanceof XSSFWorkbook;
    }

    private boolean isHSSF() {
        return this.workbook instanceof HSSFWorkbook;
    }

    private Cell getCell(Sheet sheet, int rowIndex, int colIndex, boolean create) {
        Cell cell;
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            if (create) {
                row = sheet.createRow(rowIndex);
            } else {
                return null;
            }
        }
        if ((cell = row.getCell(colIndex)) == null) {
            if (create) {
                cell = row.createCell(colIndex);
            } else {
                return null;
            }
        }
        return cell;
    }

    private Cell getCell(Sheet sheet, int rowIndex, int colIndex) {
        return this.getCell(sheet, rowIndex, colIndex, true);
    }

    private Sheet getSheet(int sheetIndex) {
        if (sheetIndex < 0 || sheetIndex >= this.workbook.getNumberOfSheets()) {
            throw new IllegalArgumentException("Sheet with index " + sheetIndex + " does not exist!");
        }
        return this.workbook.getSheetAt(sheetIndex);
    }

    private Sheet getSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new IllegalArgumentException("Sheet with name '" + sheetName + "' does not exist!");
        }
        return sheet;
    }

    public void setMissingValue(Object[] values) {
        this.missingValue = values;
    }

    private void setMissing(Cell cell) {
        if (this.missingValue.length < 1 || this.missingValue[0] == null) {
            cell.setCellType(3);
        } else {
            if (this.missingValue[0] instanceof String) {
                cell.setCellValue((String)this.missingValue[0]);
            } else if (this.missingValue[0] instanceof Double) {
                cell.setCellValue(((Double)this.missingValue[0]).doubleValue());
            } else {
                cell.setCellType(3);
                return;
            }
            cell.setCellType(1);
            this.setCellStyle(cell, (CellStyle)DataFormatOnlyCellStyle.get(DataType.String));
        }
    }

    private void setAlternativeActiveSheet(int sheetIndex) {
        if (sheetIndex == this.getActiveSheetIndex()) {
            boolean ok = false;
            for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                if (i == sheetIndex || this.workbook.isSheetHidden(i) || this.workbook.isSheetVeryHidden(i)) continue;
                this.setActiveSheet(i);
                ok = true;
                break;
            }
            if (!ok) {
                throw new IllegalArgumentException("Cannot hide or remove sheet as there would be no alternative active sheet left!");
            }
        }
    }

    public CellStyle getCellStyle(String name) {
        if (this.isHSSF()) {
            return HCellStyle.get((HSSFWorkbook)this.workbook, name);
        }
        if (this.isXSSF()) {
            return XCellStyle.get((XSSFWorkbook)this.workbook, name);
        }
        return null;
    }

    private CellStyle getCellStyle(Cell cell) {
        return new SSCellStyle(this.workbook, cell.getCellStyle());
    }

    public void setCellStyle(Cell c, CellStyle cs) {
        if (cs != null) {
            if (cs instanceof HCellStyle) {
                HCellStyle.set((HSSFCell)c, (HCellStyle)cs);
            } else if (cs instanceof XCellStyle) {
                XCellStyle.set((XSSFCell)c, (XCellStyle)cs);
            } else if (cs instanceof DataFormatOnlyCellStyle) {
                CellStyle csx = this.getCellStyle(c);
                csx.setDataFormat(this.dataFormatMap.get((Object)((DataFormatOnlyCellStyle)cs).getDataType()));
                SSCellStyle.set(c, (SSCellStyle)csx);
            } else {
                SSCellStyle.set(c, (SSCellStyle)cs);
            }
        }
    }

    public void setCellStyle(String formula, CellStyle cs) {
        CellReference[] crefs;
        AreaReference aref = new AreaReference(formula);
        String sheetName = aref.getFirstCell().getSheetName();
        if (sheetName == null) {
            throw new IllegalArgumentException("Invalid formula reference - should be of the form Sheet!A1:B10");
        }
        Sheet sheet = this.getSheet(sheetName);
        for (CellReference cref : crefs = aref.getAllReferencedCells()) {
            Cell c = this.getCell(sheet, cref.getRow(), cref.getCol());
            this.setCellStyle(c, cs);
        }
    }

    public void setCellStyle(int sheetIndex, int row, int col, CellStyle cs) {
        Cell c = this.getCell(this.getSheet(sheetIndex), row, col);
        this.setCellStyle(c, cs);
    }

    public void setCellStyle(String sheetName, int row, int col, CellStyle cs) {
        Cell c = this.getCell(this.getSheet(sheetName), row, col);
        this.setCellStyle(c, cs);
    }

    private Map<String, CellStyle> getStyles(DataFrame data, Sheet sheet, int startRow, int startCol) {
        HashMap<String, CellStyle> cstyles = new HashMap<String, CellStyle>(data.columns());
        switch (this.styleAction) {
            case XLCONNECT: {
                int i;
                if (data.hasColumnHeader()) {
                    for (i = 0; i < data.columns(); ++i) {
                        cstyles.put(HEADER + i, this.defaultStyles.get(HEADER_STYLE));
                    }
                }
                block15: for (i = 0; i < data.columns(); ++i) {
                    switch (data.getColumnType(i)) {
                        case Boolean: {
                            cstyles.put(COLUMN + i, this.defaultStyles.get(BOOLEAN_STYLE));
                            continue block15;
                        }
                        case DateTime: {
                            cstyles.put(COLUMN + i, this.defaultStyles.get(DATETIME_STYLE));
                            continue block15;
                        }
                        case Numeric: {
                            cstyles.put(COLUMN + i, this.defaultStyles.get(NUMERIC_STYLE));
                            continue block15;
                        }
                        case String: {
                            cstyles.put(COLUMN + i, this.defaultStyles.get(STRING_STYLE));
                            continue block15;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown column type detected!");
                        }
                    }
                }
                break;
            }
            case DATATYPE: {
                int i;
                if (data.hasColumnHeader()) {
                    for (i = 0; i < data.columns(); ++i) {
                        cstyles.put(HEADER + i, this.defaultStyles.get(HEADER_STYLE));
                    }
                }
                for (i = 0; i < data.columns(); ++i) {
                    cstyles.put(COLUMN + i, this.dataTypeStyles.get((Object)data.getColumnType(i)));
                }
                break;
            }
            case NONE: {
                break;
            }
            case PREDEFINED: {
                if (data.hasColumnHeader()) {
                    for (int i = 0; i < data.columns(); ++i) {
                        cstyles.put(HEADER + i, this.getCellStyle(this.getCell(sheet, startRow, startCol + i)));
                    }
                }
                int styleRow = startRow + (data.hasColumnHeader() ? 1 : 0);
                for (int i = 0; i < data.columns(); ++i) {
                    Cell cell = this.getCell(sheet, styleRow, startCol + i);
                    cstyles.put(COLUMN + i, this.getCellStyle(cell));
                }
                break;
            }
            case STYLE_NAME_PREFIX: {
                CellStyle cs;
                String prefix;
                int i;
                if (data.hasColumnHeader()) {
                    for (i = 0; i < data.columns(); ++i) {
                        prefix = this.styleNamePrefix + SEP + HEADER;
                        cs = this.getCellStyle(prefix + SEP + data.getColumnName(i));
                        if (cs == null) {
                            cs = this.getCellStyle(prefix + SEP + (i + 1));
                        }
                        if (cs == null) {
                            cs = this.getCellStyle(prefix);
                        }
                        if (cs == null) {
                            cs = new SSCellStyle(this.workbook, this.workbook.getCellStyleAt((short)0));
                        }
                        cstyles.put(HEADER + i, cs);
                    }
                }
                for (i = 0; i < data.columns(); ++i) {
                    prefix = this.styleNamePrefix + SEP + COLUMN;
                    cs = this.getCellStyle(prefix + SEP + data.getColumnName(i));
                    if (cs == null) {
                        cs = this.getCellStyle(prefix + SEP + (i + 1));
                    }
                    if (cs == null) {
                        cs = this.getCellStyle(prefix + SEP + data.getColumnType(i).toString());
                    }
                    if (cs == null) {
                        cs = new SSCellStyle(this.workbook, this.workbook.getCellStyleAt((short)0));
                    }
                    cstyles.put(COLUMN + i, cs);
                }
                break;
            }
            case DATA_FORMAT_ONLY: {
                int i;
                if (data.hasColumnHeader()) {
                    for (i = 0; i < data.columns(); ++i) {
                        cstyles.put(HEADER + i, DataFormatOnlyCellStyle.get(DataType.String));
                    }
                }
                for (i = 0; i < data.columns(); ++i) {
                    cstyles.put(COLUMN + i, DataFormatOnlyCellStyle.get(data.getColumnType(i)));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Style action not supported!");
            }
        }
        return cstyles;
    }

    public void mergeCells(int sheetIndex, String reference) {
        this.getSheet(sheetIndex).addMergedRegion(CellRangeAddress.valueOf((String)reference));
    }

    public void mergeCells(String sheetName, String reference) {
        this.getSheet(sheetName).addMergedRegion(CellRangeAddress.valueOf((String)reference));
    }

    public void unmergeCells(int sheetIndex, String reference) {
        Sheet sheet = this.getSheet(sheetIndex);
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cra = sheet.getMergedRegion(i);
            if (!cra.formatAsString().equals(reference)) continue;
            sheet.removeMergedRegion(i);
            break;
        }
    }

    public void unmergeCells(String sheetName, String reference) {
        this.unmergeCells(this.workbook.getSheetIndex(sheetName), reference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Workbook getWorkbook(File excelFile, boolean create) throws FileNotFoundException, IOException, InvalidFormatException {
        if (excelFile.exists()) {
            return new Workbook(excelFile);
        }
        if (!create) throw new FileNotFoundException("File '" + excelFile.getName() + "' could not be found - " + "you may specify to automatically create the file if not existing.");
        String filename = excelFile.getName().toLowerCase();
        if (filename.endsWith(".xls")) {
            return new Workbook(excelFile, SpreadsheetVersion.EXCEL97);
        }
        if (!filename.endsWith(".xlsx")) throw new IllegalArgumentException("File extension \"" + filename.substring(filename.lastIndexOf(46) + 1) + "\" not supported! Only *.xls and *.xlsx are allowed!");
        return new Workbook(excelFile, SpreadsheetVersion.EXCEL2007);
    }

    public static Workbook getWorkbook(String filename, boolean create) throws FileNotFoundException, IOException, InvalidFormatException {
        return Workbook.getWorkbook(new File(filename), create);
    }

    public void setCellFormula(Cell c, String formula) {
        c.setCellFormula(formula);
    }

    public void setCellFormula(String formulaDest, String formulaString) {
        CellReference[] crefs;
        AreaReference aref = new AreaReference(formulaDest);
        String sheetName = aref.getFirstCell().getSheetName();
        Sheet sheet = this.getSheet(sheetName);
        for (CellReference cref : crefs = aref.getAllReferencedCells()) {
            Cell c = this.getCell(sheet, cref.getRow(), cref.getCol());
            this.setCellFormula(c, formulaString);
        }
    }

    public void setCellFormula(int sheetIndex, int row, int col, String formula) {
        Cell c = this.getCell(this.getSheet(sheetIndex), row, col);
        this.setCellFormula(c, formula);
    }

    public void setCellFormula(String sheetName, int row, int col, String formula) {
        Cell c = this.getCell(this.getSheet(sheetName), row, col);
        this.setCellFormula(c, formula);
    }

    public String getCellFormula(Cell c) {
        return c.getCellFormula();
    }

    public String getCellFormula(int sheetIndex, int row, int col) {
        Cell c = this.getCell(this.getSheet(sheetIndex), row, col);
        return this.getCellFormula(c);
    }

    public String getCellFormula(String sheetName, int row, int col) {
        Cell c = this.getCell(this.getSheet(sheetName), row, col);
        return this.getCellFormula(c);
    }

    public boolean getForceFormulaRecalculation(int sheetIndex) {
        return this.getSheet(sheetIndex).getForceFormulaRecalculation();
    }

    public boolean getForceFormulaRecalculation(String sheetName) {
        return this.getSheet(sheetName).getForceFormulaRecalculation();
    }

    public void setForceFormulaRecalculation(int sheetIndex, boolean value) {
        this.getSheet(sheetIndex).setForceFormulaRecalculation(value);
    }

    public void setForceFormulaRecalculation(String sheetName, boolean value) {
        this.getSheet(sheetName).setForceFormulaRecalculation(value);
    }

    public void setAutoFilter(int sheetIndex, String reference) {
        this.getSheet(sheetIndex).setAutoFilter(CellRangeAddress.valueOf((String)reference));
    }

    public void setAutoFilter(String sheetName, String reference) {
        this.getSheet(sheetName).setAutoFilter(CellRangeAddress.valueOf((String)reference));
    }

    public int getLastRow(int sheetIndex) {
        return this.getSheet(sheetIndex).getLastRowNum();
    }

    public int getLastRow(String sheetName) {
        return this.getSheet(sheetName).getLastRowNum();
    }

    public int getLastColumn(Sheet sheet) {
        int lastRow = sheet.getLastRowNum();
        short lastColumn = 1;
        for (int i = 0; i < lastRow; ++i) {
            short col;
            Row row = sheet.getRow(i);
            if (row == null || (col = row.getLastCellNum()) <= lastColumn) continue;
            lastColumn = col;
        }
        return lastColumn - 1;
    }

    public int getLastColumn(int sheetIndex) {
        return this.getLastColumn(this.getSheet(sheetIndex));
    }

    public int getLastColumn(String sheetName) {
        return this.getLastColumn(this.getSheet(sheetName));
    }

    public void appendNamedRegion(DataFrame data, String name, boolean header) {
        Sheet sheet = this.workbook.getSheet(this.getName(name).getSheetName());
        int[] coord = this.getReferenceCoordinates(name);
        this.writeData(data, sheet, coord[2] + 1, coord[1], header);
        int bottom = coord[2] + data.rows();
        int right = Math.max(coord[1] + data.columns() - 1, coord[3]);
        CellRangeAddress cra = new CellRangeAddress(coord[0], bottom, coord[1], right);
        String formula = cra.formatAsString(sheet.getSheetName(), true);
        this.createName(name, formula, true);
    }

    public void appendWorksheet(DataFrame data, int worksheetIndex, boolean header) {
        int n;
        short s;
        Sheet sheet = this.getSheet(worksheetIndex);
        int lastRow = this.getLastRow(worksheetIndex);
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < lastRow && s > 0; ++i) {
            Row row = sheet.getRow(i);
            if (row == null || row.getFirstCellNum() >= s) continue;
            s = row.getFirstCellNum();
        }
        if (s == Integer.MAX_VALUE) {
            n = 0;
        }
        this.writeWorksheet(data, worksheetIndex, this.getLastRow(worksheetIndex) + 1, n, header);
    }

    public void appendWorksheet(DataFrame data, String worksheetName, boolean header) {
        this.appendWorksheet(data, this.workbook.getSheetIndex(worksheetName), header);
    }

    public void clearSheet(int sheetIndex) {
        int lastRow;
        Sheet sheet = this.getSheet(sheetIndex);
        int firstRow = sheet.getFirstRowNum();
        for (int i = lastRow = sheet.getLastRowNum(); i >= firstRow; --i) {
            Row r = sheet.getRow(i);
            if (r == null) continue;
            sheet.removeRow(r);
        }
    }

    public void clearSheet(String sheetName) {
        this.clearSheet(this.workbook.getSheetIndex(sheetName));
    }

    public void clearRange(int sheetIndex, int[] coords) {
        Sheet sheet = this.getSheet(sheetIndex);
        for (int i = coords[0]; i <= coords[2]; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = coords[1]; j <= coords[3]; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) continue;
                row.removeCell(cell);
            }
            if (row.getLastCellNum() >= 0) continue;
            sheet.removeRow(row);
        }
    }

    public void clearRange(String sheetName, int[] coords) {
        this.clearRange(this.workbook.getSheetIndex(sheetName), coords);
    }

    public void clearRangeFromReference(String reference) {
        AreaReference ref = new AreaReference(reference);
        CellReference firstCell = ref.getFirstCell();
        CellReference lastCell = ref.getLastCell();
        String sheetName = firstCell.getSheetName();
        int[] coords = new int[]{firstCell.getRow(), firstCell.getCol(), lastCell.getRow(), lastCell.getCol()};
        this.clearRange(sheetName, coords);
    }

    public void clearNamedRegion(String name) {
        String sheetName = this.getName(name).getSheetName();
        int[] coords = this.getReferenceCoordinates(name);
        this.clearRange(sheetName, coords);
    }

    public void createFreezePane(int sheetIndex, int colSplit, int rowSplit, int leftColumn, int topRow) {
        if (leftColumn < 0 | topRow < 0) {
            this.getSheet(sheetIndex).createFreezePane(colSplit, rowSplit);
        } else {
            this.getSheet(sheetIndex).createFreezePane(colSplit, rowSplit, leftColumn, topRow);
        }
    }

    public void createFreezePane(String sheetName, int colSplit, int rowSplit, int leftColumn, int topRow) {
        this.createFreezePane(this.workbook.getSheetIndex(sheetName), colSplit, rowSplit, leftColumn, topRow);
    }

    public void createFreezePane(int sheetIndex, int colSplit, int rowSplit) {
        this.createFreezePane(sheetIndex, colSplit, rowSplit, -1, -1);
    }

    public void createFreezePane(String sheetName, int colSplit, int rowSplit) {
        this.createFreezePane(sheetName, colSplit, rowSplit, -1, -1);
    }

    public void createSplitPane(int sheetIndex, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.getSheet(sheetIndex).createSplitPane(xSplitPos, ySplitPos, leftColumn, topRow, 0);
    }

    public void createSplitPane(String sheetName, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.createSplitPane(this.workbook.getSheetIndex(sheetName), xSplitPos, ySplitPos, leftColumn, topRow);
    }

    public void removePane(int sheetIndex) {
        this.createFreezePane(sheetIndex, 0, 0);
    }

    public void removePane(String sheetName) {
        this.createFreezePane(sheetName, 0, 0);
    }

    public void setSheetColor(int sheetIndex, int color) {
        if (this.isXSSF()) {
            Sheet sheet = this.workbook.getSheetAt(sheetIndex);
            ((XSSFSheet)sheet).setTabColor(color);
        } else if (this.isHSSF()) {
            // empty if block
        }
    }

    public void setSheetColor(String sheetName, int color) {
        if (this.isXSSF()) {
            Sheet sheet = this.workbook.getSheet(sheetName);
            ((XSSFSheet)sheet).setTabColor(color);
        } else if (this.isHSSF()) {
            this.addWarning("Setting the sheet color for XLS files is not supported yet.");
        }
    }

    public int[] getBoundingBox(int sheetIndex, int startRow, int startCol, int endRow, int endCol) {
        return this.getBoundingBox(sheetIndex, startRow, startCol, endRow, endCol, true, true);
    }

    public int[] getBoundingBox(int sheetIndex, int startRow, int startCol, int endRow, int endCol, boolean autofitRow, boolean autofitCol) {
        Sheet sheet = this.workbook.getSheetAt(sheetIndex);
        int mark = 0x7FFFFFFE;
        if (startRow < 0 && sheet.getRow(startRow = sheet.getFirstRowNum()) == null) {
            startRow = -1;
        }
        if (endRow < 0 && sheet.getRow(endRow = sheet.getLastRowNum()) == null) {
            endRow = -1;
        }
        int minRow = startRow;
        int maxRow = endRow;
        int minCol = startCol;
        int maxCol = endCol < 0 ? 0x7FFFFFFE : endCol;
        startCol = startCol < 0 ? 0x7FFFFFFE : startCol;
        endCol = endCol < 0 ? -1 : endCol;
        Cell topLeft = null;
        Cell bottomRight = null;
        boolean anyCell = false;
        for (int i = minRow; i > -1 && i <= maxRow; ++i) {
            Row r = sheet.getRow(i);
            if (r == null) continue;
            int start = Math.max(minCol, r.getFirstCellNum());
            int end = Math.min(maxCol + 1, r.getLastCellNum());
            boolean anyNonBlank = false;
            for (int j = start; j > -1 && j < end; ++j) {
                Cell c = r.getCell(j);
                if (c == null || c.getCellType() == 3) continue;
                anyCell = true;
                anyNonBlank = true;
                if (!(!autofitCol && minCol >= 0 || topLeft != null && j >= startCol)) {
                    startCol = j;
                    topLeft = c;
                }
                if (!autofitCol && maxCol != 0x7FFFFFFE || bottomRight != null && j <= endCol) continue;
                endCol = j;
                bottomRight = c;
            }
            if (!autofitRow || !anyNonBlank) continue;
            endRow = i;
            if (sheet.getRow(startRow) != null) continue;
            startRow = i;
        }
        if ((autofitRow || startRow < 0) && !anyCell) {
            endRow = -1;
            startRow = -1;
        }
        if ((autofitCol || startCol == 0x7FFFFFFE) && !anyCell) {
            endCol = -1;
            startCol = -1;
        }
        return new int[]{startRow, startCol, endRow, endCol};
    }

    public int[] getBoundingBox(String sheetName, int startRow, int startCol, int endRow, int endCol, boolean autofitRow, boolean autofitColumn) {
        return this.getBoundingBox(this.workbook.getSheetIndex(sheetName), startRow, startCol, endRow, endCol, autofitRow, autofitColumn);
    }

    public int[] getBoundingBox(String sheetName, int startRow, int startCol, int endRow, int endCol) {
        return this.getBoundingBox(sheetName, startRow, startCol, endRow, endCol, true, true);
    }
}

