/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.integration.r;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.integration.r.RCellStyleWrapper;
import com.miraisolutions.xlconnect.integration.r.RDataFrameWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public final class RWorkbookWrapper {
    private final Workbook workbook;

    public RWorkbookWrapper(String filename, boolean create) throws FileNotFoundException, IOException, InvalidFormatException {
        this.workbook = Workbook.getWorkbook(filename, create);
    }

    public final String[] getSheets() {
        return this.workbook.getSheets();
    }

    public final int getSheetPos(String sheetName) {
        return this.workbook.getSheetPos(sheetName);
    }

    public final void setSheetPos(String sheetName, int pos) {
        this.workbook.setSheetPos(sheetName, pos);
    }

    public final String[] getDefinedNames(boolean validOnly) {
        return this.workbook.getDefinedNames(validOnly);
    }

    public final void createSheet(String name) {
        this.workbook.createSheet(name);
    }

    public final void createName(String name, String formula, boolean overwrite) {
        this.workbook.createName(name, formula, overwrite);
    }

    public final void removeName(String name) {
        this.workbook.removeName(name);
    }

    public final String getReferenceFormula(String name) {
        return this.workbook.getReferenceFormula(name);
    }

    public final void removeSheet(String name) {
        this.workbook.removeSheet(name);
    }

    public final void removeSheet(int sheetIndex) {
        this.workbook.removeSheet(sheetIndex);
    }

    public final void renameSheet(String name, String newName) {
        this.workbook.renameSheet(name, newName);
    }

    public final void renameSheet(int sheetIndex, String newName) {
        this.workbook.renameSheet(sheetIndex, newName);
    }

    public final void cloneSheet(int index, String newName) {
        this.workbook.cloneSheet(index, newName);
    }

    public final void cloneSheet(String name, String newName) {
        this.workbook.cloneSheet(name, newName);
    }

    public final void writeNamedRegion(RDataFrameWrapper dataFrame, String name, boolean header) {
        this.workbook.writeNamedRegion(dataFrame.dataFrame, name, header);
    }

    private static DataType[] fromString(String[] colTypes) {
        DataType[] ctypes = null;
        if (colTypes != null) {
            ctypes = new DataType[colTypes.length];
            for (int i = 0; i < colTypes.length; ++i) {
                ctypes[i] = RWorkbookWrapper.fromString(colTypes[i]);
            }
        }
        return ctypes;
    }

    public final RDataFrameWrapper readNamedRegion(String string, boolean bl, String[] stringArray, boolean bl2, String string2, boolean bl3, int[] nArray) {
        DataFrame dataFrame = ((RWorkbookWrapper)((Object)dataFrame)).workbook.readNamedRegion(string, bl, RWorkbookWrapper.fromString(stringArray), bl2, string2, bl3, nArray);
        return new RDataFrameWrapper(dataFrame);
    }

    public final boolean existsName(String name) {
        return this.workbook.existsName(name);
    }

    public final boolean existsSheet(String name) {
        return this.workbook.existsSheet(name);
    }

    public final RDataFrameWrapper readWorksheet(int n, int n2, int n3, int n4, int n5, boolean bl, String[] stringArray, boolean bl2, String string, boolean bl3, int[] nArray, boolean bl4, boolean bl5) {
        DataFrame dataFrame = ((RWorkbookWrapper)((Object)dataFrame)).workbook.readWorksheet(n, n2, n3, n4, n5, bl, RWorkbookWrapper.fromString(stringArray), bl2, string, bl3, nArray, bl4, bl5);
        return new RDataFrameWrapper(dataFrame);
    }

    public final RDataFrameWrapper readWorksheet(String string, int n, int n2, int n3, int n4, boolean bl, String[] stringArray, boolean bl2, String string2, boolean bl3, int[] nArray, boolean bl4, boolean bl5) {
        DataFrame dataFrame = ((RWorkbookWrapper)((Object)dataFrame)).workbook.readWorksheet(string, n, n2, n3, n4, bl, RWorkbookWrapper.fromString(stringArray), bl2, string2, bl3, nArray, bl4, bl5);
        return new RDataFrameWrapper(dataFrame);
    }

    public final void writeWorksheet(RDataFrameWrapper dataFrame, int worksheetIndex, int startRow, int startCol, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetIndex, startRow, startCol, header);
    }

    public final void writeWorksheet(RDataFrameWrapper dataFrame, String worksheetName, int startRow, int startCol, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetName, startRow, startCol, header);
    }

    public final void writeWorksheet(RDataFrameWrapper dataFrame, int worksheetIndex, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetIndex, header);
    }

    public final void writeWorksheet(RDataFrameWrapper dataFrame, String worksheetName, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetName, header);
    }

    public final int getActiveSheetIndex() {
        return this.workbook.getActiveSheetIndex();
    }

    public final String getActiveSheetName() {
        return this.workbook.getActiveSheetName();
    }

    public final void setActiveSheet(int sheetIndex) {
        this.workbook.setActiveSheet(sheetIndex);
    }

    public final void setActiveSheet(String sheetName) {
        this.workbook.setActiveSheet(sheetName);
    }

    public final void hideSheet(int sheetIndex, boolean veryHidden) {
        this.workbook.hideSheet(sheetIndex, veryHidden);
    }

    public final void hideSheet(String sheetName, boolean veryHidden) {
        this.workbook.hideSheet(sheetName, veryHidden);
    }

    public final void unhideSheet(int sheetIndex) {
        this.workbook.unhideSheet(sheetIndex);
    }

    public final void unhideSheet(String sheetName) {
        this.workbook.unhideSheet(sheetName);
    }

    public final boolean isSheetHidden(int sheetIndex) {
        return this.workbook.isSheetHidden(sheetIndex);
    }

    public final boolean isSheetHidden(String sheetName) {
        return this.workbook.isSheetHidden(sheetName);
    }

    public final boolean isSheetVeryHidden(int sheetIndex) {
        return this.workbook.isSheetVeryHidden(sheetIndex);
    }

    public final boolean isSheetVeryHidden(String sheetName) {
        return this.workbook.isSheetVeryHidden(sheetName);
    }

    public final void addImage(String filename, String name, boolean originalSize) throws FileNotFoundException, IOException {
        this.workbook.addImage(filename, name, originalSize);
    }

    public final RCellStyleWrapper createCellStyle(String name) {
        CellStyle cs = ((RWorkbookWrapper)((Object)this)).workbook.createCellStyle(name);
        return new RCellStyleWrapper(cs);
    }

    public final RCellStyleWrapper createCellStyle() {
        CellStyle cs = ((RWorkbookWrapper)((Object)this)).workbook.createCellStyle();
        return new RCellStyleWrapper(cs);
    }

    public final RCellStyleWrapper getCellStyle(String name) {
        CellStyle cs = ((RWorkbookWrapper)((Object)this)).workbook.getCellStyle(name);
        if (cs != null) {
            return new RCellStyleWrapper(cs);
        }
        throw new IllegalArgumentException("Cell style " + name + " does not exist");
    }

    public final void setMissingValue(Object[] value) {
        this.workbook.setMissingValue(value);
    }

    private static DataType fromString(String dataType) {
        if ("BOOLEAN".equals(dataType)) {
            return DataType.Boolean;
        }
        if ("NUMERIC".equals(dataType)) {
            return DataType.Numeric;
        }
        if ("STRING".equals(dataType)) {
            return DataType.String;
        }
        if ("DATETIME".equals(dataType)) {
            return DataType.DateTime;
        }
        throw new IllegalArgumentException("Provided data type is not a valid data type!");
    }

    public final void setDataFormat(String dataType, String format) {
        this.workbook.setDataFormat(RWorkbookWrapper.fromString(dataType), format);
    }

    public final void setStyleAction(String string) {
        if ("XLCONNECT".equals(string)) {
            this.workbook.setStyleAction(StyleAction.XLCONNECT);
            return;
        }
        if ("NONE".equals(string)) {
            this.workbook.setStyleAction(StyleAction.NONE);
            return;
        }
        if ("PREDEFINED".equals(string)) {
            this.workbook.setStyleAction(StyleAction.PREDEFINED);
            return;
        }
        if ("STYLE_NAME_PREFIX".equals(string)) {
            this.workbook.setStyleAction(StyleAction.STYLE_NAME_PREFIX);
            return;
        }
        if ("DATA_FORMAT_ONLY".equals(string)) {
            this.workbook.setStyleAction(StyleAction.DATA_FORMAT_ONLY);
            return;
        }
        throw new IllegalArgumentException("Provided action is not a valid style action!");
    }

    public final void setStyleNamePrefix(String prefix) {
        this.workbook.setStyleNamePrefix(prefix);
    }

    public final void setCellStyle(String sheetName, int row, int col, RCellStyleWrapper cellStyle) {
        this.workbook.setCellStyle(sheetName, row, col, cellStyle.cellStyle);
    }

    public final void setCellStyle(int sheetIndex, int row, int col, RCellStyleWrapper cellStyle) {
        this.workbook.setCellStyle(sheetIndex, row, col, cellStyle.cellStyle);
    }

    public final void setCellStyle(String formula, RCellStyleWrapper cellStyle) {
        this.workbook.setCellStyle(formula, cellStyle.cellStyle);
    }

    public final void setColumnWidth(int sheetIndex, int columnIndex, int width) {
        this.workbook.setColumnWidth(sheetIndex, columnIndex, width);
    }

    public final void setColumnWidth(String sheetName, int columnIndex, int width) {
        this.workbook.setColumnWidth(sheetName, columnIndex, width);
    }

    public final void setRowHeight(int sheetIndex, int rowIndex, double height) {
        this.workbook.setRowHeight(sheetIndex, rowIndex, (float)height);
    }

    public final void setRowHeight(String sheetName, int rowIndex, double height) {
        this.workbook.setRowHeight(sheetName, rowIndex, (float)height);
    }

    public final void mergeCells(int sheetIndex, String reference) {
        this.workbook.mergeCells(sheetIndex, reference);
    }

    public final void mergeCells(String sheetName, String reference) {
        this.workbook.mergeCells(sheetName, reference);
    }

    public final void unmergeCells(int sheetIndex, String reference) {
        this.workbook.unmergeCells(sheetIndex, reference);
    }

    public final void unmergeCells(String sheetName, String reference) {
        this.workbook.unmergeCells(sheetName, reference);
    }

    public final String[] retrieveWarnings() {
        return this.workbook.retrieveWarnings();
    }

    public final void onErrorCell(String string) {
        if ("STOP".equals(string)) {
            this.workbook.onErrorCell(ErrorBehavior.THROW_EXCEPTION);
            return;
        }
        this.workbook.onErrorCell(ErrorBehavior.WARN);
    }

    public final void save(String file) throws FileNotFoundException, IOException {
        this.workbook.save(file);
    }

    public final void save() throws FileNotFoundException, IOException {
        this.workbook.save();
    }

    public final void setCellFormula(String sheetName, int row, int col, String formula) {
        this.workbook.setCellFormula(sheetName, row, col, formula);
    }

    public final void setCellFormula(int sheetIndex, int row, int col, String formula) {
        this.workbook.setCellFormula(sheetIndex, row, col, formula);
    }

    public final String getCellFormula(int sheetIndex, int row, int col) {
        return this.workbook.getCellFormula(sheetIndex, row, col);
    }

    public final String getCellFormula(String sheetName, int row, int col) {
        return this.workbook.getCellFormula(sheetName, row, col);
    }

    public final int[] getReferenceCoordinates(String name) {
        return this.workbook.getReferenceCoordinates(name);
    }

    public final void setForceFormulaRecalculation(int sheetIndex, boolean value) {
        this.workbook.setForceFormulaRecalculation(sheetIndex, value);
    }

    public final void setForceFormulaRecalculation(String sheetName, boolean value) {
        this.workbook.setForceFormulaRecalculation(sheetName, value);
    }

    public final boolean getForceFormulaRecalculation(int sheetIndex) {
        return this.workbook.getForceFormulaRecalculation(sheetIndex);
    }

    public final boolean getForceFormulaRecalculation(String sheetName) {
        return this.workbook.getForceFormulaRecalculation(sheetName);
    }

    public final void setAutoFilter(int sheetIndex, String reference) {
        this.workbook.setAutoFilter(sheetIndex, reference);
    }

    public final void setAutoFilter(String sheetName, String reference) {
        this.workbook.setAutoFilter(sheetName, reference);
    }

    public final int getLastRow(int sheetIndex) {
        return this.workbook.getLastRow(sheetIndex);
    }

    public final int getLastRow(String sheetName) {
        return this.workbook.getLastRow(sheetName);
    }

    public final int getLastColumn(int sheetIndex) {
        return this.workbook.getLastColumn(sheetIndex);
    }

    public final int getLastColumn(String sheetName) {
        return this.workbook.getLastColumn(sheetName);
    }

    public final void appendNamedRegion(RDataFrameWrapper data, String name, boolean header) {
        this.workbook.appendNamedRegion(data.dataFrame, name, header);
    }

    public final void appendWorksheet(RDataFrameWrapper data, int worksheetIndex, boolean header) {
        this.workbook.appendWorksheet(data.dataFrame, worksheetIndex, header);
    }

    public final void appendWorksheet(RDataFrameWrapper data, String worksheetName, boolean header) {
        this.workbook.appendWorksheet(data.dataFrame, worksheetName, header);
    }

    public final void clearSheet(int sheetIndex) {
        this.workbook.clearSheet(sheetIndex);
    }

    public final void clearSheet(String sheetName) {
        this.workbook.clearSheet(sheetName);
    }

    public final void clearRange(int sheetIndex, int[] coords) {
        this.workbook.clearRange(sheetIndex, coords);
    }

    public final void clearRange(String sheetName, int[] coords) {
        this.workbook.clearRange(sheetName, coords);
    }

    public final void clearRangeFromReference(String reference) {
        this.workbook.clearRangeFromReference(reference);
    }

    public final void clearNamedRegion(String name) {
        this.workbook.clearNamedRegion(name);
    }

    public final void createFreezePane(int sheetIndex, int colSplit, int rowSplit, int leftColumn, int topRow) {
        this.workbook.createFreezePane(sheetIndex, colSplit, rowSplit, leftColumn, topRow);
    }

    public final void createFreezePane(String sheetName, int colSplit, int rowSplit, int leftColumn, int topRow) {
        this.workbook.createFreezePane(sheetName, colSplit, rowSplit, leftColumn, topRow);
    }

    public final void createFreezePane(int sheetIndex, int colSplit, int rowSplit) {
        this.workbook.createFreezePane(sheetIndex, colSplit, rowSplit);
    }

    public final void createFreezePane(String sheetName, int colSplit, int rowSplit) {
        this.workbook.createFreezePane(sheetName, colSplit, rowSplit);
    }

    public final void createSplitPane(int sheetIndex, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.workbook.createSplitPane(sheetIndex, xSplitPos, ySplitPos, leftColumn, topRow);
    }

    public final void createSplitPane(String sheetName, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.workbook.createSplitPane(sheetName, xSplitPos, ySplitPos, leftColumn, topRow);
    }

    public final void removePane(int sheetIndex) {
        this.workbook.removePane(sheetIndex);
    }

    public final void removePane(String sheetName) {
        this.workbook.removePane(sheetName);
    }

    public final void setSheetColor(int sheetIndex, int color) {
        this.workbook.setSheetColor(sheetIndex, color);
    }

    public final void setSheetColor(String sheetName, int color) {
        this.workbook.setSheetColor(sheetName, color);
    }

    public final int[] getBoundingBox(int sheetIndex, int startRow, int startCol, int endRow, int endCol, boolean autofitRow, boolean autofitCol) {
        return this.workbook.getBoundingBox(sheetIndex, startRow, startCol, endRow, endCol, autofitRow, autofitCol);
    }

    public final int[] getBoundingBox(String sheetName, int startRow, int startCol, int endRow, int endCol, boolean autofitRow, boolean autofitCol) {
        return this.workbook.getBoundingBox(sheetName, startRow, startCol, endRow, endCol, autofitRow, autofitCol);
    }
}

