% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xReport.r
\name{xReport}
\alias{xReport}
\title{Function to generate a html-formatted report}
\usage{
xReport(
obj,
rmd = NULL,
output_format = NULL,
output_file = NULL,
output_dir = NULL,
quiet = T,
verbose = T,
...
)
}
\arguments{
\item{obj}{an R object. Usually a S3-class object storing results such
as an 'eTerm' object}

\item{rmd}{the R markdown file. If NULL, the pre-prepared one in the
directory 'inst/DynamicReport' of the XGR package will be used}

\item{output_format}{the output format rendered from the R markdown
file. If NULL, the output format is the first one defined within the R
markdown file. The advanced use is to pass an output format object via
rmarkdown::html_document()}

\item{output_file}{the name of the output file. If NULL, the output
filename will be based on the filename of R markdown file (extension
replaced)}

\item{output_dir}{the directory of the output file}

\item{quiet}{the logic specifying whether to suppress printing of the
pandoc command line}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{...}{additional parameters used in rmarkdown::render}
}
\value{
the message on the rendered output file and directory.
}
\description{
\code{xReport} is supposed to generate a html-formatted report.
}
\note{
none
}
\examples{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

\donttest{
res <- xReport(eTerm)

# advanced use
output_format <-
rmarkdown::html_document(number_sections=T,theme="journal",
hightlight="espresso",code_folding="hide")
res <- xReport(eTerm, output_format=output_format)
}
}
\seealso{
\code{\link{xReport}}
}
