% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGeneID2Symbol.r
\name{xGeneID2Symbol}
\alias{xGeneID2Symbol}
\title{Function to convert gene symbols to entrez geneid}
\usage{
xGeneID2Symbol(data, org = c("human", "mouse"), details = F,
verbose = T, RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{an input vector containing gene symbols}

\item{org}{a character specifying an organism. Currently supported
organisms are 'human' and 'mouse'. It can be an object 'EG'}

\item{details}{logical to indicate whether to result in a data frame
(in great details). By default, it sets to false}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a vector containing symbol with 'NA' for the unmatched if (details set
to false); otherwise, a data frame is returned
}
\description{
\code{xGeneID2Symbol} is supposed to convert gene symbols to entrez
geneid.
}
\note{
none.
}
\examples{
\dontrun{
# Load the library
library(XGR)

# a) provide the input Genes of interest (eg 100 randomly chosen human genes)
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg')
GeneID <- sample(org.Hs.eg$gene_info$GeneID, 100)
GeneID

# b) convert into GeneID
Symbol <- xGeneID2Symbol(GeneID)

# c) convert into a data frame
df <- xGeneID2Symbol(GeneID, details=TRUE)


# advanced use
df <- xGeneID2Symbol(GeneID, org=org.Hs.eg, details=TRUE)
}
}
\seealso{
\code{\link{xEnricherGenes}}, \code{\link{xSocialiserGenes}}
}
