% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.mrt3arm}
\alias{wp.mrt3arm}
\title{Statistical Power Analysis for Multisite Randomized Trials with 3 Arms}
\usage{
wp.mrt3arm(n = NULL, f1 = NULL, f2 = NULL, J = NULL, tau = NULL,
  sg2 = NULL, power = NULL, alpha = 0.05, alternative = c("two.sided",
  "one.sided"), type = c("main", "treatment", "omnibus"), interval = NULL)
}
\arguments{
\item{n}{Sample size. It is the number of individuals within each cluster.}

\item{f1}{Effect size for treatment main effect. Effect size must be positive.}

\item{f2}{Effect size for the difference between two treatments. Effect size must be positive.}

\item{J}{Number of clusters / sites. It tells how many clusters are considered in the study design. At least two clusters are required.}

\item{tau}{Variance of treatment effects across sites/clusters.}

\item{sg2}{Level-one error Variance. The residual variance in the first level.}

\item{power}{Statistical power.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{alternative}{Type of the alternative hypothesis (\code{"two.sided"} or \code{"one.sided"}). The default is "two.sided". The option "one.sided" can be either "less" or "greater".}

\item{type}{Type of effect (\code{"main"} or \code{"treatment"} or \code{"omnibus"}) with "main" as default.
The type "main" tests the difference between the average treatment arms and the control arm;
Type "treatment" tests the difference between the two treatment arms;
and Type "omnibus" tests whether the three arms are all equivalent.}
\item{interval}{A vector containing the end-points of the interval to be searched for the root.}

}
\value{
An object of the power analysis.
}
\description{
Multisite randomized trials (MRT) are a type of multilevel design for the situation when the entire cluster is randomly assigned to either a treatment arm or a control arm \cite{(Liu, 2013)}.
The data from MRT can be analyzed in a two-level hierarchical linear model, where the indicator variable for treatment assignment is included in first level. If a study contains multiple treatments, then multiple indicators will be used.
This function is for designs with 3 arms (i.e., two treatments and a control).
Three types of tests are considered in the function: (1) The "main" type tests treatment main effect;
(2) The "treatment" type tests the difference between the two treatments;
and (3) The "omnibus" type tests whether the three arms are all equivalent.
Details leading to power calculation can be found in \cite{Raudenbush (1997)} and \cite{Liu (2013)}.
}
\examples{
#To calculate the statistical power given sample size and effect size:
#For main effect
wp.mrt3arm(n = 30, f1 = 0.43, J = 20, tau = 0.4,
               sg2 = 2.25, alpha = 0.05, power = NULL)
#    Multisite randomized trials with 3 arms
#
#       J  n   f1 tau  sg2     power alpha
#      20 30 0.43 0.4 2.25 0.8066964  0.05
#  
#    NOTE: n is the number of subjects per cluster
#    URL: http://psychstat.org/mrt3arm

#For tesing difference between effects
wp.mrt3arm(n = 30, f2 = 0.2, J = 20, tau = 0.4, sg2 = 2.25,
                      alpha = 0.05, power = NULL, type="treatment")
#    Multisite randomized trials with 3 arms
#
#      J  n  f2 tau  sg2     power alpha
#      20 30 0.2 0.4 2.25 0.2070712  0.05
# 
#    NOTE: n is the number of subjects per cluster
#    URL: http://psychstat.org/mrt3arm

#For testing site variablity
wp.mrt3arm(n = 30, f1=0.43, f2 = 0.2, J = 20, tau = 0.4, sg2 = 2.25,
                          alpha = 0.05, power = NULL, type="omnibus")
#    Multisite randomized trials with 3 arms
#
#       J  n   f1  f2 tau  sg2     power alpha
#      20 30 0.43 0.2 0.4 2.25 0.7950757  0.05
#  
#    NOTE: n is the number of subjects per cluster
#    URL: http://psychstat.org/mrt3arm

#To generate a power curve given a sequence of numbers of sites/clusters:
res <- wp.mrt3arm(n = 30, f2 = 0.2, J = seq(20,120,10), tau = 0.4,
            sg2 = 2.25, alpha = 0.05, power = NULL, type="treatment")
res
#    Multisite randomized trials with 3 arms
#
#       J  n  f2 tau  sg2     power alpha
#      20 30 0.2 0.4 2.25 0.2070712  0.05
#      30 30 0.2 0.4 2.25 0.2953799  0.05
#      40 30 0.2 0.4 2.25 0.3804554  0.05
#      50 30 0.2 0.4 2.25 0.4603091  0.05
#      60 30 0.2 0.4 2.25 0.5337417  0.05
#      70 30 0.2 0.4 2.25 0.6001544  0.05
#      80 30 0.2 0.4 2.25 0.6593902  0.05
#      90 30 0.2 0.4 2.25 0.7116052  0.05
#     100 30 0.2 0.4 2.25 0.7571648  0.05
#     110 30 0.2 0.4 2.25 0.7965644  0.05
#     120 30 0.2 0.4 2.25 0.8303690  0.05
# 
#    NOTE: n is the number of subjects per cluster
#    URL: http://psychstat.org/mrt3arm

#To plot the power curve:
plot(res, "J", "power")

#To calculate the required sample size given power and effect size:
wp.mrt3arm(n = NULL, f1 = 0.43, J = 20, tau = 0.4,
                sg2 = 2.25, alpha = 0.05, power = 0.8)
#    Multisite randomized trials with 3 arms
#
#       J        n   f1 tau  sg2 power alpha
#      20 28.61907 0.43 0.4 2.25   0.8  0.05
#  
#    NOTE: n is the number of subjects per cluster
#    URL: http://psychstat.org/mrt3arm

}
\references{
Liu, X. S. (2013). Statistical power analysis for the social and behavioral sciences: basic and advanced techniques. Routledge.

Raudenbush, S. W. (1997). Statistical analysis and optimal design for cluster randomized trials. Psychological Methods, 2(2), 173.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
