% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dur_gaps.R
\name{dur_gaps}
\alias{dur_gaps}
\title{calculate the duration of stratigraphic gaps using astronomical cycles}
\usage{
dur_gaps(
  proxies = NULL,
  retracked_period_1 = NULL,
  retracked_period_2 = NULL,
  min_max = NULL,
  n_simulations = 10,
  tracked_cycle_period = NULL,
  tracked_cycle_period_unc = NULL,
  tracked_cycle_period_unc_dist = "u",
  pts = 5,
  dj = 1/200,
  lowerPeriod = 1,
  upperPeriod = 3200,
  period_max = NULL,
  period_min = NULL,
  missing_cycle_dur = NULL,
  n_cycles_missing = 1,
  missing_cycle_unc = NULL,
  missing_cycle_unc_dist = "u",
  run_multicore = FALSE
)
}
\arguments{
\item{proxies}{list of proxies which were used to create a astrochronological
age model and which are used to calculate the duration of the gap}

\item{retracked_period_1}{A matrix of 3 columns in which the first column
is depth/height.The second column is the period of the tracked cycle.
The thirds column is uncertainty given as 1 standard deviation for the
period of the tracked cycle. The gap to be modeled should be located
in between retracked_period_1 and retracked_period_2}

\item{retracked_period_2}{A matrix of 3 columns in which the first column
is depth/height.The second column is the period of the tracked cycle.
The thirds column is uncertainty given as 1 standard deviation for the
period of the tracked cycle. The gap to be modeled should be located
in between retracked_period_1 and retracked_period_2}

\item{min_max}{list of "min" or "max" indicating whether time should be
estimated between minima or maxima for each proxy}

\item{n_simulations}{number of gap duration to calculate}

\item{tracked_cycle_period}{period in time of the tracked cycle}

\item{tracked_cycle_period_unc}{uncertainty in the period of the tracked cycle}

\item{tracked_cycle_period_unc_dist}{distribution of the uncertainty of the
tracked cycle value need to be either "u" for uniform distribution or
"n" for normal distribution  \code{Default="u"}}

\item{pts}{the pts parameter specifies how many points to the left/right up/down the peak detect algorithm goes in detecting
a peak. The peak detecting algorithm works by comparing the values left/right up/down of it, if the values are both higher or lower
then the value a peak. To deal with error produced by this algorithm the pts parameter can be changed which can
aid in peak detection. Usually increasing the pts parameter means more peak certainty, however it also means that minor peaks might not be
picked up by the algorithm \code{Default=5}#'}

\item{dj}{Spacing between successive scales. The CWT analyses analyses the signal using successive periods
which increase by the power of 2 (e.g.2^0=1,2^1=2,2^2=4,2^3=8,2^4=16). To have more resolution
in-between these steps the dj parameter exists, the dj parameter specifies how many extra steps/spacing in-between
the power of 2 scaled CWT is added. The amount of steps is 1/x with a higher x indicating a smaller spacing.
Increasing the increases the computational time of the CWT \code{Default=1/200}.}

\item{lowerPeriod}{Lowest period to be analyzed \code{Default=2}.
The CWT analyses the signal starting from the lowerPeriod to the upperPeriod so the proper selection these
parameters allows to analyze the signal for a specific range of cycles.
scaling is done using power 2 so for the best plotting results select a value to the power or 2.}

\item{upperPeriod}{Upper period to be analyzed \code{Default=1024}.
The CWT analyses the signal starting from the lowerPeriod to the upperPeriod so the proper selection these
parameters allows to analyze the signal for a specific range of cycles.
 scaling is done using power 2 so for the best plotting results select a value to the power or 2.}

\item{period_max}{Maximum period (upper boundary) to be used to extract a cycle.}

\item{period_min}{Minimum period (lower boundary) to be used to extract a cycle.}

\item{missing_cycle_dur}{duration of the missing cycles}

\item{n_cycles_missing}{number of missing cycles \code{Default=1}}

\item{missing_cycle_unc}{duration uncertainty of the missing cycle}

\item{missing_cycle_unc_dist}{distribution of the uncertainty of the
tracked cycle value need to be either "u" for uniform distribution or
"n" for normal distribution  \code{Default="u"}}

\item{run_multicore}{Run function using multiple cores \code{Default="FALSE"}}
}
\value{
a vector with all the calculated gap durations
}
\description{
calculate the duration of stratigraphic gaps using the duration
of stable astronomical cycles
}
