% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistHistBeta}
\alias{PlotDistHistBeta}
\title{Plot distribution details as a histogram plus matching beta}
\usage{
PlotDistHistBeta(frm, xvar, title, ..., binwidth = NULL, bins = 30)
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}

\item{...}{force later arguments to bind by name}

\item{binwidth}{passed to geom_histogram(). If passed in, overrides bins.}

\item{bins}{passed to geom_histogram(). Default: 30}
}
\value{
ggplot2 plot
}
\description{
Compares empirical data to a beta distribution with the same mean and standard deviation.
}
\details{
Plots the histogram of the empirical distribution and the density of the matching beta distribution.
Also plots the mean and plus/minus one standard deviation.

The number of bins for the histogram defaults to 30.
The binwidth can also be passed in instead of the number of bins.
}
\examples{

set.seed(52523)
d <- data.frame(wt=rbeta(100,shape1=0.5,shape2=0.5))
PlotDistHistBeta(d,'wt','example')

}
