% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daydat.R
\docType{data}
\name{daydat}
\alias{daydat}
\title{Daily chlorophyll, salinity, and discharge time series for the Upper Patuxent River Estuary}
\format{A data frame with 3506 rows and 9 variables, 1985 to 2014:
\describe{
  \item{\code{date}}{Date as daily time step} 
  \item{\code{flo}}{numeric for salinity, ppt}
  \item{\code{lnres}}{numeric for chlorophyll fluorescence as ln-transformed ug/l}
  \item{\code{Q}}{numeric for daily discharge m3/s}
  \item{\code{lnQ}}{numeric for daily discharge ln-transformed m3/s}
  \item{\code{jday}}{numeric for julian day}
  \item{\code{year}}{numeric for year}
  \item{\code{day}}{numeric for day from 1-31}
  \item{\code{dec_time}}{numeric for decimal time on the annual period}
}}
\usage{
daydat
}
\description{
Combined daily flow observations from the USGS stream gage station 01594440 near Bowie, Maryland and daily chlorophyll and salinity records from the Jug Bay station of the Chesapeake Bay Maryland National Estuarine Research Reserve.  Daily chlorophyll concentrations were estimated from fluorescence values that did not include blue-green algae blooms.  These date are provided to illustrate examples with time series simulation.
}
\keyword{datasets}
