% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wals.R
\name{wals}
\alias{wals}
\alias{wals.formula}
\alias{wals.matrix}
\alias{wals.default}
\title{Weighted-Average Least Squares for linear regression models}
\usage{
wals(x, ...)

\method{wals}{formula}(
  formula,
  data,
  subset = NULL,
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  prior = weibull(),
  model = TRUE,
  keepY = TRUE,
  keepX = FALSE,
  sigma = NULL,
  ...
)

\method{wals}{matrix}(
  x,
  x2,
  y,
  subset = NULL,
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  prior = weibull(),
  keepY = TRUE,
  keepX = FALSE,
  sigma = NULL,
  ...
)

\method{wals}{default}(x, ...)
}
\arguments{
\item{x}{Design matrix of focus regressors. Usually includes a constant
(column full of 1s) and can be generated using \code{\link[stats]{model.matrix}}.}

\item{...}{Arguments for workhorse \code{\link[WALS]{walsFit}}.}

\item{formula}{an object of class \code{"\link[Formula]{Formula}"}
(or one that can be coerced to that class, e.g. \code{"\link[stats]{formula}"}):
a symbolic description of the model to be fitted.
The details of model specification are given under ‘Details’.}

\item{data}{an optional data frame, list or environment
(or object coercible by \code{\link[base]{as.data.frame}} to a data frame)
containing the variables in the model. If not found in \code{data}, the variables
are taken from \code{environment(formula)}, typically the environment which
the function is called from.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{\strong{not implemented yet.}}

\item{weights}{\strong{not implemented yet.}}

\item{offset}{\strong{not implemented yet.}}

\item{prior}{Object of class \code{"\link[WALS]{familyPrior}"}. For example
\code{\link[WALS]{weibull}} or \code{\link[WALS]{laplace}}.}

\item{model}{if \code{TRUE} (default), then the model.frame is stored in
the return.}

\item{keepY}{if \code{TRUE} (default), then the response is stored in
the return.}

\item{keepX}{if \code{TRUE}, then the model matrices are stored in the return.
the return.}

\item{sigma}{if NULL (default), then the variance of the error term is
estimated. See \code{\link[WALS]{walsFit}} for more details.}

\item{x2}{Design matrix of auxiliary regressors. Usually does not include
a constant column and can also be generated using \code{\link[stats]{model.matrix}}.}

\item{y}{Response as vector.}
}
\value{
\code{wals.formula()} returns an object of class
\code{"wals"}. This is a list that contains all elements returned from
\code{\link[WALS]{walsFit}} and additionally
\item{y}{If \code{keepY = TRUE}, contains the response vector.}
\item{x}{list. If \code{keepX = TRUE}, then it is a list with elements
\code{x1} and \code{x2} containing the design matrices of the focus and
auxiliary regressors, respectively.}
\item{weights}{returns the argument \code{weights}.}
\item{offset}{returns the argument \code{offset}.}
\item{cl}{Call of the function.}
\item{formula}{\code{formula} used.}
\item{terms}{List containing the model terms of the focus and auxiliary
regressors separately, as well as for the full model.}
\item{levels}{List containing the levels of the focus and auxiliary
regressors separately, as well as for the full model.}
\item{contrasts}{List containing the contrasts of the design matrices of
focus and auxiliary regressors.}
\item{model}{If \code{model = TRUE}, contains the model frame.}

See returns of \code{\link[WALS]{walsFit}} for more details.

\code{wals.matrix()} returns an object of class \code{"walsMatrix"},
which inherits from \code{"wals"}. This is a list that contains all elements
returned from \code{\link[WALS]{walsFit}} and additionally the response \code{y},
the list \code{x} with model matrices \code{x1} and \code{x2}, the call
\code{cl}, \code{offset} and \code{weights}.

\code{wals.default()} raises an error if \code{x} is not an object
of class \code{"matrix"} or a class that extends \code{"matrix"}. Otherwise
returns an object of class \code{"walsMatrix"}. See above for more details.
}
\description{
Performs model averaging for linear regression models using the
Weighted-Average Least Squares method by
\insertCite{magnus2010growth;textual}{WALS}. See also
\insertCite{deluca2011stata;textual}{WALS},
\insertCite{kumar2013normallocation;textual}{WALS} and
\insertCite{magnus2016wals;textual}{WALS}.
}
\details{
R port of MATLAB code wals.m (version 2.0, revision 18 December 2013)
by J.R. Magnus and G. De Luca, available from
\url{https://www.janmagnus.nl/items/WALS.pdf}.
Calculates WALS estimates when focus regressors (X1) are present in all
submodels and model averaging takes place over the auxiliary regressors (X2).

Formulas typically contain two parts, i.e. they are of the form
"\code{y ~ X11 + X12 | X21 + X22}", where the variables before "\code{|}" are
the focus regressors (includes a constant by default) and the ones after
"\code{|}" are the auxiliary regressors. If only a one-part formula is
specified, then all regressors are considered as auxiliary regressors and only
a constant is employed as focus regressor, i.e.
"\code{y ~ X1 + X2}" is equivalent to "\code{y ~ 1 | X1 + X2}".

\strong{WARNING:} Interactions in formula do not work properly yet.
It is recommended to manually create the interactions beforehand and then
to insert them as 'linear terms' in the formula.

\code{wals.default()} raises an error if \code{x} is not an object of class
\code{"matrix"} or a class that extends \code{"matrix"}. Otherwise it calls
\code{wals.matrix()}. It is a modified version of \code{glmboost.default}
from the \code{mboost} package version 2.9-8 (2023-09-06) \insertCite{mboost}{WALS}.
}
\examples{
## Replicate table on p. 534 of De Luca & Magnus (2011)
fitDM <- wals(gdpgrowth ~ lgdp60 + equipinv + school60 + life60 + popgrowth |
                  law + tropics + avelf + confucian, data = GrowthMPP,
                prior = laplace())
tableDM <- cbind("coef" = coef(fitDM), "se" = sqrt(diag(vcov(fitDM))))
print(round(tableDM, 7))


## Replicate first panel of Table I in Amini & Parmeter (2012)
data("datafls", package = "BMS")

# NOTE: Authors manually scale data, then rescale the resulting coefs and se.
X <- model.matrix(y ~ ., data = datafls)
Xscaled <- apply(X, MARGIN = 2, function(x) x/max(x))
Xscaled <- Xscaled[,-1]
scaleVector <- apply(X, MARGIN = 2, function(x) max(x))
flsScaled <- as.data.frame(cbind(y = datafls$y, Xscaled))

# NOTE: prescale = FALSE, still used old version of WALS in Magnus et al. (2010).
# Not recommended anymore!
fitFLS <- wals(y ~ 1 | ., data = flsScaled, prescale = FALSE, eigenSVD = FALSE,
               prior = laplace())
tableFLS <- cbind('coef' = coef(fitFLS)/scaleVector,
                  'se' = sqrt(diag(vcov(fitFLS)))/scaleVector)
printVars <- c("(Intercept)", "GDP60", "Confucian", "LifeExp", "EquipInv",
               "SubSahara", "Muslim", "RuleofLaw")
print(round(tableFLS[printVars,], 4))


## Replicate third panel of Table I in Amini & Parmeter (2012)
data("SDM", package = "BayesVarSel")

# rescale response
SDM$y <- SDM$y / 100

# NOTE: Authors manually scale data, then rescale the resulting coefs and se.
X <- model.matrix(y ~ ., data = SDM)
Xscaled <- apply(X, MARGIN = 2, function(x) x/max(x))
Xscaled <- Xscaled[,-1]
scaleVector <- apply(X, MARGIN = 2, function(x) max(x))
SDMscaled <- as.data.frame(cbind(y = SDM$y, Xscaled))

# NOTE: prescale = FALSE, still used old version of WALS in Magnus et al. (2010).
# Not recommended anymore!
fitDW <- wals(y ~ 1 | ., data = SDMscaled, prescale = FALSE, eigenSVD = FALSE,
              prior = laplace())
tableDW <- cbind(coef(fitDW)/scaleVector, sqrt(diag(vcov(fitDW)))/scaleVector)
printVars <- c("(Intercept)", "EAST", "P60", "IPRICE1", "GDPCH60L", "TROPICAR")
print(round(tableDW[printVars,], 5))

## Example for wals.matrix()
X <- model.matrix(mpg ~ disp + hp + wt + vs + am + carb, data = mtcars)
X1 <- X[,c("(Intercept)", "disp", "hp", "wt")] # focus
X2 <- X[,c("vs", "am", "carb")] # auxiliary
y <- mtcars$mpg

wals(X1, X2, y, prior = weibull())

}
\references{
\insertAllCited{}
}
