% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsGLM.R, R/walsNB.R
\name{predict.walsGLM}
\alias{predict.walsGLM}
\alias{predict.walsGLMmatrix}
\alias{residuals.walsGLM}
\alias{print.walsGLM}
\alias{summary.walsGLM}
\alias{print.summary.walsGLM}
\alias{logLik.walsGLM}
\alias{summary.walsNB}
\alias{print.summary.walsNB}
\title{Methods for walsGLM, walsGLMmatrix, walsNB and walsNBmatrix Objects}
\usage{
\method{predict}{walsGLM}(
  object,
  newdata,
  type = c("response", "link", "variance", "prob", "density", "logDens"),
  at = NULL,
  na.action = na.pass,
  log = FALSE,
  ...
)

\method{predict}{walsGLMmatrix}(
  object,
  newX1,
  newX2,
  newY = NULL,
  type = c("response", "link", "variance", "prob", "density", "logDens"),
  at = NULL,
  log = FALSE,
  ...
)

\method{residuals}{walsGLM}(object, type = c("deviance", "pearson", "response"), ...)

\method{print}{walsGLM}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{walsGLM}(object, ...)

\method{print}{summary.walsGLM}(x, digits = max(3, getOption("digits") - 3), ...)

\method{logLik}{walsGLM}(object, ...)

\method{summary}{walsNB}(object, ...)

\method{print}{summary.walsNB}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object, x}{An object of class \code{"walsGLM"}, \code{"walsGLMmatrix"},
\code{"walsNB"}, \code{"walsNBmatrix"}, \code{"summary.walsGLM"} or
\code{"summary.walsNB"}.}

\item{newdata}{Optionally, a data frame in which to look for variables with
which to predict. If omitted, the original observations are used.}

\item{type}{Character specifying the type of prediction, residual or model
part to be returned. For details see below.}

\item{at}{Optional. Only available if a family of class \code{"\link[WALS]{familyWALScount}"}
was used for fitting. If \code{type = "prob"}, a numeric vector at which
the probabilities are evaluated. By default \code{0:max(y)} is used
where \code{y} is the original observed response.}

\item{na.action}{Function determining what should be done with missing values
in \code{newdata}. The default is to predict \code{NA}.}

\item{log}{Logical. If \code{TRUE}, then returns the log-density. If
\code{FALSE} (default), then returns density. Only relevant if
\code{type = "density"}.}

\item{...}{Further arguments passed to methods.}

\item{newX1}{Focus regressors matrix to be used for the prediction.}

\item{newX2}{Auxiliary regressors matrix to be used for the prediction.}

\item{newY}{Response vector to be used in predictions. Only relevant when
\code{type = "prob"}, \code{type = "density"} or \code{type = "logDens"}.}

\item{digits}{The number of significant digits to display.}
}
\value{
\code{predict.walsGLM()} and \code{predict.walsGLMmatrix()} return
different types of predictions depending on the argument \code{type}:
\itemize{
\item \code{type = "response"}: vector. Predicted mean
\item \code{type = "link"}: vector. Predicted linear link
\item \code{type = "variance"}: vector. Predicted variance
\item \code{type = "prob"}: matrix. Only available if a family of class
\code{"\link[WALS]{familyWALScount}"} was used for fitting or for objects of
class \code{"walsNB"} or \code{"walsNBmatrix"}. Returns the probability at
counts specified by \code{at}.
\item \code{type = "density"}: vector. Predicted density
\item \code{type = "logDens"}: vector. For convenience, returns predicted log-density.
Equivalent to setting \code{type = "density"} and \code{log = TRUE}.
}

If \code{type = "prob"}, \code{type = "density"} or \code{type = "logDens"},
then \code{newdata} must contain the response or \code{newY} must be
specified depending on the class of the object.

\code{residuals.walsGLM()} returns different types of residuals
depending on the argument \code{type}:
\itemize{
\item \code{type = "deviance"}: deviance residuals
\item \code{type = "pearson"}: Pearson residuals (raw residuals scaled by
square root of variance function)
\item \code{type = "response"}: raw residuals (observed - fitted)
}

\code{print.walsGLM()} invisibly returns its input argument \code{x},
i.e. an object of object of class \code{"walsGLM"}.

\code{summary.walsGLM()} returns an object of class
\code{"summary.walsGLM"} which contains the necessary fields for printing the
summary in \code{print.summary.walsGLM()}.

\code{print.summary.walsGLM()} invisibly returns its input argument
\code{x}, i.e. an object of object of class \code{"summary.walsGLM"}.

\code{logLik.walsGLM()} returns the log-likelihood of the fitted
model.

\code{summary.walsNB()} returns an object of class
\code{"summary.walsNB"} which contains the necessary fields for printing the
summary in \code{print.summary.walsNB()}.

\code{print.summary.walsNB()} invisibly returns its input argument
\code{x}, i.e. an object of object of class \code{"summary.walsNB"}.
}
\description{
Methods for extracting information from fitted model-averaging objects of
classes \code{"walsGLM"}, \code{"walsGLMmatrix"}, \code{"walsNB"} and
\code{"walsNBmatrix"}.
}
\details{
As the \code{"-matrix"} classes \code{"walsGLMmatrix"} and \code{"walsNBmatrix"}
inherit from the "non-matrix" classes, i.e. \code{"walsGLM"} and \code{"walsNB"},
respectively, the following text will treat them as equivalent because
they inherit all methods but \code{predict} from their "non-matrix" versions.
Thus, when \code{"walsGLM"} or \code{"walsNB"} are mentioned, we also refer to
their \code{"-matrix"} versions, except when explicitly stated. Moreover,
note that \code{"walsNB"} and \code{"walsNBmatrix"} inherit most methods from
\code{"walsGLM"} and \code{"walsGLMmatrix"}.

A set of standard extractor functions for fitted model objects is available
for objects of class \code{"walsGLM"} and \code{"walsNB"}, including methods to
the generic functions \code{\link[base]{print}} and \code{\link[base]{summary}}
which print the model-averaged estimation of the coefficients along with some
further information.

The \code{\link[base]{summary}} methods returns an object of
class \code{"summary.walsGLM"} for objects of class \code{"walsGLM"} and an
object of class \code{"summary.walsNB"} for objects of class \code{"walsNB"}.
They contain the relevant summary statistics which can then be printed using
the associated \code{print()} methods.
Inspired by \insertCite{deluca2011stata;textual}{WALS}, the summary statistics
also show \code{Kappa} which is an indicator for the numerical stability of
the method, i.e. it shows the square root of the condition number of the
matrix \eqn{\bar{\Xi} = \bar{\Delta}_{2} \bar{X}_{2}^{\top} \bar{M}_{1}
\bar{X}_{2} \bar{\Delta}_{2}}. The summary further shows the deviance and
provides information on the prior and family used.

A \code{\link[stats]{logLik}} method is provided that returns the log-likelihood
given the family used and the model-averaged estimates of the coefficients.

\code{"walsGLM"} inherits from \code{"wals"}, while \code{"walsNB"} inherits from
both, \code{"walsGLM"} and \code{"wals"}. Thus, see \code{\link[WALS]{predict.wals}}
for more methods.

The \code{\link[stats]{predict}} and \code{\link[stats]{residuals}} methods,
especially the different types of predictions/residuals controlled by
\code{type}, are inspired by the corresponding methods in \code{countreg}
version 0.2-1 (2023-06-13) \insertCite{countreg,countreghurdle}{WALS}, see
e.g. \code{predict.hurdle()} from \code{countreg}, and \code{\link[stats]{stats}}
version 4.3.1 (2023-06-16) \insertCite{R2023}{WALS}, see e.g.
\code{\link[stats]{residuals.glm}}. The \code{summary()}, \code{print.summary()},
\code{print()} and \code{logLik()} methods are also inspired by the corresponding
methods for objects of class \code{"glm"} in \code{\link[stats]{stats}}, see
e.g. \code{\link[stats]{print.summary.glm}}.

\code{\link[stats]{coef}} and \code{\link[stats]{vcov}} are inherited from
\code{"wals"} (see \code{\link[WALS]{predict.wals}} for more), except for
objects of class \code{"walsNB"} (see \code{\link[WALS]{vcov.walsNB}}).
The \code{type} argument specifies which part of the coefficient
vector/covariance matrix of the estimates should be returned.
For \code{type = "all"}, they return the complete vector/matrix.
For \code{type = "focus"} and \code{type = "aux"} they return only the part
corresponding to the focus and auxiliary regressors, respectively.
Additionally, the user can choose whether to return the
estimated coefficients/covariance matrix for the original regressors \eqn{X}
(\eqn{\beta} coefficients) or of the transformed regressors \eqn{Z}
(\eqn{\gamma} coefficients).

The extractors \code{\link[stats]{terms}} and \code{\link[stats]{model.matrix}}
are also inherited from \code{"wals"}. They only allow \code{type = "focus"}
and \code{type = "aux"} and extract the corresponding component of the model.
}
\examples{
## Example for walsGLM objects
data("HMDA", package = "AER")
fitBinomial <- walsGLM(deny ~ pirat + hirat + lvrat + chist + mhist + phist |
                        selfemp + afam, family = binomialWALS(), data = HMDA,
                       prior = weibull())
summary(fitBinomial)
vcov(fitBinomial, type = "focus")
logLik(fitBinomial)
predict(fitBinomial, newdata = HMDA[1:10,], type = "response")
familyWALS(fitBinomial)

## Example for walsNB objects
data("NMES1988", package = "AER")

fWals <- (visits ~ chronic + age + I((age^2)/10) + insurance + medicaid |
           adl + gender + married + income + school + afam + employed)
fitNB <- walsNB(fWals, data = NMES1988, link = "log", prior = weibull(),
                method = "fullSVD")
summary(fitNB)
coef(fitNB, type = "aux")
residuals(fitNB, type = "pearson")
predict(fitNB, newdata = NMES1988[1:10,], type = "prob")
terms(fitNB, type = "aux")

}
\references{
\insertAllCited{}
}
\seealso{
\link{walsGLM}, \link{walsNB}, \link{predict.wals}.
}
