% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{printfp}
\alias{printfp}
\title{printfp - to paste, format and print a string}
\usage{
printfp(x, ...)
}
\arguments{
\item{x}{a list of format string to concatenate before using sprintf on it.}

\item{...}{
  Arguments passed on to \code{\link[base:paste]{base::paste}}
  \describe{
    \item{\code{sep}}{a character string to separate the terms.  Not
    \code{\link[base]{NA_character_}}.}
    \item{\code{collapse}}{an optional character string to separate the results.  Not
    \code{\link[base]{NA_character_}}.}
    \item{\code{recycle0}}{\code{\link[base]{logical}} indicating if zero-length
    character arguments should lead to the zero-length
    \code{\link[base]{character}(0)} after the \code{sep}-phase (which turns into
    \code{""} in the \code{collapse}-phase, i.e., when \code{collapse} is
    not \code{NULL}).}
  }}
}
\description{
printfp calls paste and sprintf of its parameters to build the error message
and prints with the given message
}
\examples{

file <- "/tmp/test"
printfp(
  list(
    "Very log error message that needs to be cut on multiple lines,",
    "and paste back together, but there are formatings like",
    "\%\%s for example, that provides a placeholder for parameters.",
    "Here \%\%s value is \%s."
  ), file
)

}
\author{
L.Pavot
}
