% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{make_diff_template}
\alias{make_diff_template}
\title{Make Template for Pairwise Significance Input}
\usage{
make_diff_template(
  estimates,
  include_zero = TRUE,
  include_intercept = FALSE,
  ...
)
}
\arguments{
\item{estimates}{A vector of point estimates (ideally, a named vector).}

\item{include_zero}{Logical indicating whether tests against zero should be included.}

\item{include_intercept}{Logical indicating whether the intercept should be included.}

\item{...}{Other arguments passed down, currently not implemented.}
}
\value{
A two-column data frame containing the names of the larger and smaller parameters in the appropriate order. This can be
used to identify the appropriate order in which to specify the \code{sig_diffs} argument to \code{viztest()}.
}
\description{
Provides a template for producing a binary vector indicating whether each pair of
estimates has a significant difference.
}
\details{
The \code{viztest()} function uses a normal difference of means test to identify
whether there is a significant difference or not.  While this test could be done
with adjustments for multiplicity or robust standard errors of all different kinds,
there may be times when the user would prefer to identify the significant differences
manually.  The \code{viztest()} function internally reorders the estimates from largest to smallest
so this function does that and then prints the pairs that will correspond with the
visual testing grid search being done by \code{viztest()}.

Please note that the \code{include_zero} and \code{include_intercept} arguments should be set the same
here as they are in your call to \code{viztest()}.  If they are not, \code{viztest()} will stop because
the results from the comparison of confidence intervals will have different dimensions than the
differences that are manually provides.
}
\examples{
make_diff_template(estimates = c(e1 = 2, e2 = 1, e3 = 3))
}
