% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_validation}
\alias{plot_validation}
\title{Plot a ribbon plot with each time horizon predictions against true values for validation}
\usage{
plot_validation(data, validation_res, pred_plot = "ribbon")
}
\arguments{
\item{data}{A data frame used in \code{\link[=generate_validation]{generate_validation()}}, containing the
original training data used for model fitting. Must include:
\itemize{
\item \code{date}: Dates of the observed data (class \code{Date}).
\item \code{confirm}: Numeric values of confirmed cases.
}}

\item{validation_res}{A list of forecast validation results, typically
produced by \code{\link[=generate_validation]{generate_validation()}}. Each element should include:
\itemize{
\item \code{forecast_res_quantiles}: A data frame containing forecasted quantiles
(\code{p025}, \code{p10}, \code{p25}, \code{p50}, \code{p75}, \code{p90}, \code{p975}, and \code{date}).
\item \code{estimate_R}: A list with estimated reproduction numbers (used for
grouping).
\item \code{smoothed_data}: (optional) A data frame of smoothed observations,
if smoothing was applied before forecasting.
}}

\item{pred_plot}{either \code{"ribbon"} or \code{"error_bar"} (by default) to produce either ribbon prediction plots or error_bar plots respectively}
}
\value{
error_bar validation plot or ribbon validation plot for a specific prediction horizon
}
\description{
Plot a ribbon plot with each time horizon predictions against true values for validation
}
\examples{
data <- simulate_data()
formatted_data <- get_aggregated_data(data,"date", "flu_a", "2024-10-16", "2024-12-31")
start_date <- ("2024-10-16")
validation_results <- generate_validation(formatted_data, start_date, type ="flu_a")
plot_validation(formatted_data, validation_results)

}
