#' Compare Reproduction Number Estimates from Multiple EpiEstim Outputs
#'
#' @description
#' `r lifecycle::badge("deprecated")`
#'
#' This function is deprecated and may be removed in a future release.
#'
#' This function creates a ggplot comparing estimated reproduction numbers (\eqn{R})
#' over time from multiple EpiEstim outputs. Each input should be a named object
#' produced by EpiEstim containing an `estimate_R$R` data frame.
#'
#' @param ... Named EpiEstim output objects produced by [generate_forecast()].
#' Each object should contain a data frame `estimate_R$R` with columns such as:
#'   - `t_start`, `t_end`: Time window indices
#'   - `Median(R)`: Median estimated reproduction number
#'   - `Quantile.0.025(R)` / `Quantile.0.975(R)`: 95% credible interval bounds
#'   - `Quantile.0.25(R)` / `Quantile.0.75(R)`: 50% credible interval bounds
#'
#' @return
#' A **ggplot2** object showing median \eqn{R} estimates with 50% and 95% credible intervals,
#' colored by input source (i.e., name).
#'
#' @seealso [generate_forecast()], [EpiEstim::estimate_R()]
#' @keywords internal

plot_R_fit_comparison <- function(...) {
  warning("plot_R_fit_comparison() is deprecated and may be removed in a future release.")
  # lifecycle::deprecate_warn()
  t_end <- `Median(R)` <- `Quantile.0.025(R)` <- `Quantile.0.975(R)` <- NULL
  window <- `Quantile.0.25(R)` <- `Quantile.0.75(R)` <- NULL
  t_start <- time <- type <- NULL
  epiestim_list <- list(...)

  plot_obj <- list()
  for (name in names(epiestim_list)) {
    epiestim_obj <- epiestim_list[[name]]
    plot_obj[[name]] <- epiestim_obj$estimate_R$R |>
      mutate(
        type = name
      )
  }

  g <- dplyr::bind_rows(plot_obj) |>
    dplyr::mutate(time = .5 * (t_end + t_start)) |>
    ggplot2::ggplot(ggplot2::aes(x = `time`, y = `Median(R)`)) +
    ggplot2::geom_ribbon(ggplot2::aes(
      ymin = `Quantile.0.025(R)`, ymax = `Quantile.0.975(R)`,
      fill = type
    ), alpha = 0.2) +
    ggplot2::geom_ribbon(ggplot2::aes(
      ymin = `Quantile.0.25(R)`, ymax = `Quantile.0.75(R)`,
      fill = type
    ), alpha = 0.2) +
    ggplot2::geom_line(ggplot2::aes(color = type)) +
    ggplot2::geom_hline(yintercept = 1, linetype = "dashed", color = "grey") +
    ggplot2::theme_classic() +
    ggplot2::theme(legend.position = "bottom") +
    ggplot2::labs(x = "time", y = "R", color = "", fill = "")

  return(g)
}

#' @title Compare Forecast Outputs
#'
#' @description
#' `r lifecycle::badge("deprecated")`
#'
#' This function is deprecated and may be removed in a future release.
#'
#' This function visualizes and compares multiple forecast outputs generated by
#' `generate_forecast()`.
#' It plots median predicted incidences with 80% and 90% predictive intervals.
#'
#' @param ... Named forecast result objects produced by [generate_forecast()].
#' Each object should contain a data frame `forecast_res_quantiles` with columns:
#'   - `date`: Forecast date
#'   - `p10`, `p50`, `p90`: 10th, median, and 90th quantile predictions
#'   - (Optional) other quantiles if available
#'
#' @return
#' A **ggplot2** object showing forecasted median incidences over time with shaded
#' prediction intervals, colored by input source (i.e., model name).
#'
#' @seealso [generate_forecast()], [ggplot2::ggplot()]
#' @keywords internal
plot_forecast_comparison <- function(...) {
  warning("plot_forecast_comparison() is deprecated and may be removed in a future release.")
  `p50` <- `p10` <- `p90` <- NULL
  date <- incidence <- sim <- type <- NULL
  quant <- val <- NULL

  obj_list <- list(...)
  plot_obj <- list()
  for (name in names(obj_list)) {
    obj <- obj_list[[name]]
    plot_obj[[name]] <- obj$forecast_res_quantiles |>
      mutate(
        type = name
      )
  }

  g <- dplyr::bind_rows(plot_obj) |>
   ggplot2:: ggplot(ggplot2::aes(x=`date`,y=`p50`)) +
    ggplot2::geom_ribbon(ggplot2::aes(
      ymin = `p10`, ymax = `p90`,
      fill = type
    ), alpha = 0.2) +
    ggplot2::geom_line(ggplot2::aes(y=`p50`, color = type)) +
    ggplot2::theme_classic() +
    ggplot2::theme(legend.position = "bottom") +
    ggplot2::labs(x = "time", y = "incidence", color = "", fill = "")

  return(g)
}


#' Plot Mean Rt with time index (dates)
#' @param forecast_results is the output of \code{generate_forecast}.
#' @return Mean Rt with time index plot
#' @importFrom rlang .data
#' @examples
#' # Create sample test rsv data
#' disease_type <- "rsv"
#' test_data <- simulate_data()
#' formatted_data <- get_aggregated_data(
#'   test_data,
#'   number_column = disease_type,
#'   date_column = "date",
#'   start_date = "2024-04-01",
#'   end_date = "2024-05-01"
#' )
#'
#' # Run a 7 day forecast with smoothing
#' forecast_results <- generate_forecast(
#'   data = formatted_data,
#'   start_date = "2024-04-01",
#'   n_days = 7,
#'   type = "rsv",
#'   smooth_data = FALSE
#' )
#' plot_rt(forecast_results)
#' @export
#' 
plot_rt <- function(forecast_results) {

  # check input from forecast func
  model_data_dates <- forecast_results$original_data$date

  rt_dat <-forecast_results$estimate_R$R
  rt_start_date <- model_data_dates[rt_dat$t_start[1]]
  rt_date_seq <- seq(rt_start_date, by = "day", length.out = length(rt_dat$t_start))
  rt_dat$date <- rt_date_seq
  rt_dat <- rt_dat |>
    dplyr::mutate(
      weekly_date = lubridate::floor_date(date, unit = "week")
    ) |>
    dplyr::group_by(.data$weekly_date) |>
    dplyr::summarise(
      weekly_rt = mean(.data[["Mean(R)"]]), weekly_ymin = mean(.data[["Quantile.0.025(R)"]]),
      weekly_ymax = mean(.data[["Quantile.0.975(R)"]])
    )
  p <- ggplot2::ggplot(rt_dat, ggplot2::aes(x = .data$weekly_date)) +
    ggplot2::geom_ribbon(ggplot2::aes(ymin = .data$weekly_ymin, ymax = .data$weekly_ymax), fill = "#08519C", alpha = 0.25) +
    ggplot2::geom_line(ggplot2::aes(y = .data$weekly_rt), color = "#08519C") +
    ggplot2::theme_bw() +
    ggplot2::labs(x = "Time", y = "mean(expression(R[t]))") +
    ggplot2::geom_line(ggplot2::aes(y = .data$weekly_rt), color = "#08519C") +
    ggplot2::theme_bw() +
    ggplot2::labs(x = "Time", y = "Mean(Rt)")
  return(p)
}



#' Plot a ribbon plot with each time horizon predictions against true values for validation
#'
#' @param data A data frame used in [`generate_validation()`], containing the
#'   original training data used for model fitting. Must include:
#'   - `date`: Dates of the observed data (class `Date`).
#'   - `confirm`: Numeric values of confirmed cases.
#'
#' @param validation_res A list of forecast validation results, typically
#'   produced by [`generate_validation()`]. Each element should include:
#'   - `forecast_res_quantiles`: A data frame containing forecasted quantiles
#'     (`p025`, `p10`, `p25`, `p50`, `p75`, `p90`, `p975`, and `date`).
#'   - `estimate_R`: A list with estimated reproduction numbers (used for
#'     grouping).
#'   - `smoothed_data`: (optional) A data frame of smoothed observations,
#'     if smoothing was applied before forecasting.
#'
#' @param pred_plot either \code{"ribbon"} or \code{"error_bar"} (by default) to produce either ribbon prediction plots or error_bar plots respectively
#'
#' @return error_bar validation plot or ribbon validation plot for a specific prediction horizon
#'
#' @examples 
#' data <- simulate_data()
#' formatted_data <- get_aggregated_data(data,"date", "flu_a", "2024-10-16", "2024-12-31")
#' start_date <- ("2024-10-16")
#' validation_results <- generate_validation(formatted_data, start_date, type ="flu_a")
#' plot_validation(formatted_data, validation_results)
#' 
#' @importFrom rlang .data
#' 
#' @export
plot_validation <- function(data, validation_res, pred_plot = "ribbon") {

  if (!(pred_plot %in% c("error_bar", "ribbon"))) {
    stop("Supported plot types are 'error_bar' and 'ribbon'")
  }

  # combine each time window forecast results
  forecast_dat <- purrr::map_dfr(validation_res,
                                  ~ data.frame(date = .x$forecast_res_quantiles$date,
                                               p50 = .x$forecast_res_quantiles$p50,
                                               p10 = .x$forecast_res_quantiles$p10,
                                               p25 = .x$forecast_res_quantiles$p25,
                                               p75 = .x$forecast_res_quantiles$p75,
                                               p90 = .x$forecast_res_quantiles$p90,
                                               p025 = .x$forecast_res_quantiles$p025,
                                               p975 = .x$forecast_res_quantiles$p975,
                                               group_id = as.character(nrow(.x$estimate_R$R))))

  model_data <- dplyr::filter(data, date <= max(forecast_dat$date, na.rm = T))
  model_data$point_type <- rep("Confirmed Case (Unsmoothed)", nrow(model_data))

  forecast_dat$point_type <- rep("Mean Prediction", nrow(forecast_dat))

    n_groups <- length(unique(forecast_dat$group_id))
  blue_grad <- grDevices::colorRampPalette(c("#08519c","#00719b"))(n_groups)

  base_plot <- ggplot2::ggplot(
    data = forecast_dat,
    ggplot2::aes(
      x = .data$date, y = .data$p50, group = .data$group_id, color = .data$group_id, fill = .data$group_id
    )
  ) +
    ggplot2::geom_point(data = model_data, ggplot2::aes(x = .data$date, y = .data$confirm), colour = "black", inherit.aes = FALSE) +
    ggplot2::theme_bw() +
    ggplot2::labs(x = "Date", y = paste0("Prediction of confirmed cases", fill = "", colour = "")) +
    ggplot2::ggtitle(paste0(gsub("_"," ",paste0(toupper(substr(pred_plot, 1, 1)), substr(pred_plot, 2, nchar(pred_plot)))), " plot of predictions")) +
    ggplot2::theme(
      legend.title = ggplot2::element_blank(), legend.position = "None",
      axis.text.x = ggplot2::element_text(angle = 45, hjust = 1)
    )

  if (pred_plot == "error_bar") {
    p <- base_plot +
      ggplot2::geom_point(ggplot2::aes(y = .data$p50), size = 2) +
      ggplot2::geom_line(ggplot2::aes(y = .data$p50)) +
      ggplot2::geom_errorbar(ggplot2::aes(group = .data$date, ymin = .data$p10,
                                          ymax = .data$p90)) +
      ggplot2::scale_color_manual(values = blue_grad) +
      ggplot2::theme(legend.position = "None")
  } else if (pred_plot == "ribbon") {
    p <- base_plot +
      ggplot2::geom_ribbon(ggplot2::aes(ymin = .data$p10, ymax = .data$p90), alpha = 0.3, color = NA) +
      ggplot2::geom_line(ggplot2::aes(y = .data$p50), linewidth = 1) +
      ggplot2::scale_color_manual(values = blue_grad) +
      ggplot2::scale_fill_manual(values = blue_grad)
  }


  return(p)
}





