% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopEstList.R
\name{BiCopEstList}
\alias{BiCopEstList}
\title{List of Maximum Likelihood Estimates for Several Bivariate Copula Families}
\usage{
BiCopEstList(u1, u2, familyset = NA, weights = NA, rotations = TRUE, ...)
}
\arguments{
\item{u1, u2}{Data vectors of equal length with values in \eqn{[0,1]}.}

\item{familyset}{Vector of bivariate copula families to select from.
The vector has to include at least one bivariate copula
family that allows for positive and one that allows for negative dependence.
If \code{familyset = NA} (default), selection among all possible families is
performed.  Coding of bivariate copula families: \cr
\code{0} = independence copula \cr
\code{1} = Gaussian copula \cr
\code{2} = Student t copula (t-copula) \cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr
\code{5} = Frank copula \cr
\code{6} = Joe copula \cr
\code{7} = BB1 copula \cr
\code{8} = BB6 copula \cr
\code{9} = BB7 copula \cr
\code{10} = BB8 copula \cr
\code{13} = rotated Clayton copula (180 degrees; \verb{survival Clayton'') \\cr `14` = rotated Gumbel copula (180 degrees; }survival Gumbel'') \cr
\code{16} = rotated Joe copula (180 degrees; \verb{survival Joe'') \\cr `17` = rotated BB1 copula (180 degrees; }survival BB1'')\cr
\code{18} = rotated BB6 copula (180 degrees; \verb{survival BB6'')\\cr `19` = rotated BB7 copula (180 degrees; }survival BB7'')\cr
\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
\code{23} = rotated Clayton copula (90 degrees) \cr
`24` = rotated Gumbel copula (90 degrees) \cr
`26` = rotated Joe copula (90 degrees) \cr
`27` = rotated BB1 copula (90 degrees) \cr
`28` = rotated BB6 copula (90 degrees) \cr
`29` = rotated BB7 copula (90 degrees) \cr
`30` = rotated BB8 copula (90 degrees) \cr
`33` = rotated Clayton copula (270 degrees) \cr
`34` = rotated Gumbel copula (270 degrees) \cr
`36` = rotated Joe copula (270 degrees) \cr
`37` = rotated BB1 copula (270 degrees) \cr
`38` = rotated BB6 copula (270 degrees) \cr
`39` = rotated BB7 copula (270 degrees) \cr
`40` = rotated BB8 copula (270 degrees) \cr
`104` = Tawn type 1 copula \cr
`114` = rotated Tawn type 1 copula (180 degrees) \cr
`124` = rotated Tawn type 1 copula (90 degrees) \cr
`134` = rotated Tawn type 1 copula (270 degrees) \cr
`204` = Tawn type 2 copula \cr
`214` = rotated Tawn type 2 copula (180 degrees) \cr
`224` = rotated Tawn type 2 copula (90 degrees) \cr
`234` = rotated Tawn type 2 copula (270 degrees) \cr}

\item{weights}{Numerical; weights for each observation (optional).}

\item{rotations}{If \code{TRUE}, all rotations of the families in
\code{familyset} are included.}

\item{...}{further arguments passed to \code{\link[=BiCopEst]{BiCopEst()}}.}
}
\value{
A list containing
\item{models}{a list of \code{\link[=BiCop]{BiCop()}} objects corresponding to the
`familyset`` (only families corresponding to the sign of the empirical
Kendall's tau are used),}
\item{summary}{a data frame containing the log-likelihoods, AICs, and BICs
of all the fitted models.}
}
\description{
This function allows to compare bivariate copula models across a number of
families w.r.t. the fit statistics log-likelihood, AIC, and BIC. For each
family, the parameters are estimated by maximum likelihood.
}
\details{
First all available copulas are fitted using maximum likelihood estimation.
Then the criteria are computed for all available copula families (e.g., if
\code{u1} and \code{u2} are negatively
dependent, Clayton, Gumbel, Joe, BB1, BB6, BB7 and BB8 and their survival
copulas are not considered) and the family with the minimum value is chosen.
For observations \eqn{u_{i,j},\ i=1,...,N,\ j=1,2,}{u_{i,j}, i=1,...,N,\
j=1,2,} the AIC of a bivariate copula family \eqn{c} with parameter(s)
\eqn{\boldsymbol{\theta}} is defined as \deqn{AIC := -2 \sum_{i=1}^N
\ln[c(u_{i,1},u_{i,2}|\boldsymbol{\theta})] + 2k, }{ AIC := -2 \sum_{i=1}^N
ln[c(u_{i,1},u_{i,2}|\theta)] + 2k, } where \eqn{k=1} for one parameter
copulas and \eqn{k=2} for the two parameter t-, BB1, BB6, BB7 and BB8
copulas. Similarly, the BIC is given by \deqn{BIC := -2 \sum_{i=1}^N
\ln[c(u_{i,1},u_{i,2}|\boldsymbol{\theta})] + \ln(N)k. }{ BIC := -2
\sum_{i=1}^N ln[c(u_{i,1},u_{i,2}|\theta)] + ln(N)k. } Evidently, if the BIC
is chosen, the penalty for two parameter families is stronger than when
using the AIC.
}
\examples{
## compare models
data(daxreturns)
comp <- BiCopEstList(daxreturns[, 1], daxreturns[, 4])

}
\references{
Akaike, H. (1973). Information theory and an extension of the
maximum likelihood principle. In B. N. Petrov and F. Csaki (Eds.),
Proceedings of the Second International Symposium on Information Theory
Budapest, Akademiai Kiado, pp. 267-281.

Schwarz, G. E. (1978). Estimating the dimension of a model. Annals of
Statistics 6 (2), 461-464.
}
\seealso{
\code{\link[=BiCop]{BiCop()}},
\code{\link[=BiCopEst]{BiCopEst()}}
}
\author{
Thomas Nagler
}
