% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom.R
\name{06. Binomial coefficients}
\alias{06. Binomial coefficients}
\alias{binom}
\alias{binom.default}
\alias{binom.numeric}
\alias{binom.vli}
\title{Binomial Coefficients for vli Objects}
\usage{
binom(n, k)

\method{binom}{default}(n, k)

\method{binom}{numeric}(n, k)

\method{binom}{vli}(n, k)
}
\arguments{
\item{n}{object of class vli or 32 bits integer}

\item{k}{object of class vli or 32 bits integer}
}
\value{
object of class vli
}
\description{
\code{binom} computes binomial coefficients of vli (Very Large Integers) objects. That is, given two positive integers \code{n} and \code{k} with \code{n >= k}, the function \code{binom(n, k)} returns the number of ways to choose a subset of \code{k} elements, disregarding their order, from a set of \code{n} elements.
}
\examples{
x <- as.vli("1000")
binom(x, 200)
}
\author{
Javier Leiva Cuadrado
}
