% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarSelLCM.R
\name{VarSelCluster}
\alias{VarSelCluster}
\title{This function performs the variable selection and the maximum likelihood estimation of the Latent Class Model}
\usage{
VarSelCluster(x, g, vbleSelec = TRUE, crit.varsel = "BIC", initModel = 50,
  nbcores = 1, discrim = rep(1, ncol(x)), nbSmall = 250, iterSmall = 20,
  nbKeep = 50, iterKeep = 1000, tolKeep = 10^(-6))
}
\arguments{
\item{x}{data.frame. Rows correspond to observations and columns correspond to variables. Continuous variables must be "numeric", count variables must be "integer" and categorical variables must be "factor".}

\item{g}{numeric. It defines number of components.}

\item{vbleSelec}{logical. It indicates if a variable selection is done (TRUE: yes, FALSE: no; default is 1).}

\item{crit.varsel}{character. It defines the information criterion used for the variable selection ("AIC", "BIC" or "MICL"; only used if vbleSelec=1; default is "BIC").}

\item{initModel}{numeric. It gives the number of initializations of the alternated algorithm maximizing the MICL criterion (only used if crit.varsel="MICL"; default is 50)}

\item{nbcores}{numeric.  It defines the numerber of cores used by the alogrithm (default is 1).}

\item{discrim}{numeric. It indicates if each variable is discrimiative (1) or irrelevant (0) (only used if vbleSelec=0; default is rep(1,ncol(x))).}

\item{nbSmall}{numeric. It indicates  the number of SmallEM algorithms performed for the ML inference (default is 250).}

\item{iterSmall}{numeric. It indicates  the number of iterations for each SmallEM algorithm (default is 20).}

\item{nbKeep}{numeric. It indicates the number of chains used for the final EM algorithm (default is 50).}

\item{iterKeep}{numeric. It indicates the maximal number of iterations for each EM algorithm (default is 1000).}

\item{tolKeep}{numeric. It indicates the maximal gap between two successive iterations of EM algorithm which stops the algorithm (default is 0.001).}
}
\value{
Returns an instance of \linkS4class{VSLCMresultsMixed}.
}
\description{
This function performs the variable selection and the maximum likelihood estimation of the Latent Class Model
}
\examples{
\dontrun{
data(iris)
res.LCM <- VarSelCluster(x, 2)
summary(res.LCM)
}
}
