% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censloop_em.R
\name{censloop_em}
\alias{censloop_em}
\title{The Censored data EM loop}
\usage{
censloop_em(meanmodel, theta.old, beta.old, p.old, x.0, X, censor.ind,
  mean.intercept, maxit, eps)
}
\arguments{
\item{meanmodel}{Dataframe containing only the covariates to be fit in the mean model. NULL for zero mean model and FALSE for constant mean model.}

\item{theta.old}{Vector containing the initial variance parameter estimates to be fit in the variance model.}

\item{beta.old}{Vector containing the initial mean parameter estimates to be fit in the mean model.}

\item{p.old}{Vector of length n containing the initial variance estimate.}

\item{x.0}{Matrix of covariates (length n) to be fit in the variance model. All have been rescaled so zero is the minimum. If NULL, then its a constant variance model.}

\item{X}{Vector of length n of the outcome variable.}

\item{censor.ind}{Vector of length n of the censoring indicator. 0=uncensored, -1=left censored and 1 is right censored.}

\item{mean.intercept}{Logical to indicate if mean intercept is to be included in the model.}

\item{maxit}{Number of maximum iterations for the EM algorithm.}

\item{eps}{Very small number for the convergence criteria.}
}
\value{
A list of the results from the EM algorithm, including:
\itemize{
\item\code{conv}: Logical argument indicating if convergence occurred
\item\code{it}: Total iterations performed of the EM algorithm
 \item\code{reldiff}: the positive convergence tolerance that occured at the final iteration.
 \item\code{theta.new}: Vector of variance parameter estimates. Note that these are not yet
 transformed back to the appropriate scale
 \item\code{mean}: Vector of mean parameter estimates
 \item\code{fittedmean}: Vector of fitted mean estimates
 \item\code{p.old}: Vector of fitted variance estimates
 }
}
\description{
\code{censloop_em} is a EM loop function for censored data to be utilised by various other higher level functions.
}
