% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_avg}
\alias{plot_avg}
\title{Plots average looks to interest areas.}
\usage{
plot_avg(data, type = NULL, xlim = NA, IAColumns = NULL,
  Averaging = "Event", Condition1 = NULL, Condition2 = NULL,
  Cond1Labels = NA, Cond2Labels = NA, ErrorBar = TRUE,
  VWPreTheme = TRUE, ConfLev = 95, CItype = "simultaneous",
  ErrorBand = FALSE, ErrorType = "SE")
}
\arguments{
\item{data}{A data table object output by either \code{\link{bin_prop}}. 
\code{\link{transform_to_elogit}}, or \code{\link{create_binomial}}.}

\item{type}{A character string indicating "proportion" or "elogit" which 
influences how standard error and confidence intervals are calculated.}

\item{xlim}{A vector of two integers specifying the limits of the x-axis.}

\item{IAColumns}{A named character vector specifying the desired interest 
area columns with custom strings for the legend.}

\item{Averaging}{A character string indicating how the averaging should 
be done. "Event" (default) will produce the overall mean in the data, while
"Subject" or "Item" (or, in principle, any other column name) will
calculate the grand mean by that factor.}

\item{Condition1}{A string containing the column name corresponding to the 
first condition, if available.}

\item{Condition2}{A string containing the column name corresponding to the 
second condition, if available.}

\item{Cond1Labels}{A named character vector specifying the desired custom 
labels of the levels of the first condition.}

\item{Cond2Labels}{A named character vector specifying the desired custom 
labels of the levels of the second condition.}

\item{ErrorBar}{A logical indicating whether error bars should be
included in the plot.}

\item{VWPreTheme}{A logical indicating whether the theme included with the 
function should be applied, or ggplot2's base theme (to which any other 
custom theme could be added).}

\item{ConfLev}{A number indicating the confidence level of the CI.}

\item{CItype}{A string indicating "simultaneous" or "pointwise". Simultaneous
performs a Bonferroni correction for the interval.}

\item{ErrorBand}{A logical indicating whether error bands should be
included in the plot.}

\item{ErrorType}{A string indicating "SE" or "CI". For SE, the calculation 
varies for empirical logits and proportions. Further, for CI, the calculation
on proportions uses the Wald method.}
}
\description{
\code{plot_avg} calculates the grand or conditional averages of 
looks to each interest area along with standard error. It then plots the results.
N.B.: This function will work for data with a maximum of 8 interest areas
and 2 conditions.
}
\examples{
\dontrun{
library(VWPre)
# For plotting the grand average with the included theme and SE bars
plot_avg(data = dat, type = "elogit", xlim = c(0, 1000), 
   IAColumns = c(IA_1_ELogit = "Target", IA_2_ELogit = "Rhyme", 
   IA_3_ELogit = "OnsetComp", IA_4_ELogit = "Distractor"), 
   Averaging = "Event", Condition1 = NA, Condition2 = NA, 
   Cond1Labels = NA, Cond2Labels = NA,
   ErrorBar = TRUE, VWPreTheme = TRUE, ErrorType = "SE",
   ErrorBand = FALSE) 
   
# For plotting conditional averages (one condition) with the included theme
# and 95\% simultaneous CI bars.
# This produces plots arranged horizontally
plot_avg(data = dat, type = "elogit", xlim = c(0, 1000), 
   IAColumns = c(IA_1_ELogit = "Target", IA_2_ELogit = "Rhyme", 
   IA_3_ELogit = "OnsetComp", IA_4_ELogit = "Distractor"),
   Averaging = "Event", Condition1 = NA, Condition2 = "talker", 
   Cond1Labels = NA, 
   Cond2Labels = c(CH1 = "Chinese 1", CH10 = "Chinese 3", CH9 = "Chinese 2", 
   EN3 = "English 1"), ErrorBar = TRUE, VWPreTheme = TRUE,
   ErrorBands = FALSE, ErrorType = "CI", ConfLev = 95, CItype = "simultaneous")

# For plotting conditional averages (two conditions) for one interest area
with the included theme and 95\% simultaneous CI bands.
# This produces plots arranged in grid format.
plot_avg(data = dat, type = "elogit", xlim = c(0, 1000),
   IAColumns = c(IA_1_ELogit = "Target"), Averaging = "Event", 
   Condition1 = "talker", Condition2 = "Exp",
   Cond1Labels = c(CH1 = "Chinese 1", CH10 = "Chinese 3", CH9 = "Chinese 2", 
   EN3 = "English 1"), Cond2Labels = c(High = "H Exp", Low = "L Exp"),
   ErrorBar = FALSE, VWPreTheme = TRUE, ErrorBands = TRUE, 
   ErrorType = "CI", ConfLev = 95, CItype = "simultaneous")

#' # For a more complete tutorial on VWPre plotting functions:
vignette("SR_Plotting", package="VWPre")
}

}
