% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.VSURF.R
\name{print.VSURF}
\alias{print.VSURF}
\title{Print of VSURF results}
\usage{
\method{print}{VSURF}(x, ...)
}
\arguments{
\item{x}{An object of class \code{VSURF}, which is the result of the
\code{\link{VSURF}} function.}

\item{\dots}{Not used.}
}
\description{
This function display a small description of VSURF results
}
\examples{

\dontrun{
data(iris)
iris.vsurf <- VSURF(iris[,1:4], iris[,5], ntree = 100, nfor.thres = 20,
                    nfor.interp = 10, nfor.pred = 10)
iris.vsurf
}

}
\references{
Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2010),
\emph{Variable selection using random forests}, Pattern Recognition Letters
31(14), 2225-2236

Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2015),
\emph{VSURF: An R Package for Variable Selection Using Random Forests},
The R Journal 7(2):19-33
}
\seealso{
\code{\link{VSURF}}, \code{\link{plot.VSURF}}, \code{\link{summary.VSURF}}
}
\author{
Robin Genuer, Jean-Michel Poggi and Christine Tuleau-Malot
}
