% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.VSURF.R
\name{plot.VSURF}
\alias{plot.VSURF}
\alias{plot.VSURF_interp}
\alias{plot.VSURF_pred}
\alias{plot.VSURF_thres}
\title{Plot of VSURF results}
\usage{
\method{plot}{VSURF}(x, step = "all", var.names = FALSE, imp.mean = TRUE,
  imp.sd = TRUE, nvar.imp.mean = length(x$imp.mean.dec),
  nvar.imp.sd = length(x$imp.sd.dec),
  nvar.interp = length(x$varselect.thres),
  nvar.pred = length(x$varselect.pred), ...)

\method{plot}{VSURF_thres}(x, var.names = FALSE, imp.mean = TRUE,
  imp.sd = TRUE, nvar.imp.mean = length(x$imp.mean.dec),
  nvar.imp.sd = length(x$imp.sd.dec), ...)

\method{plot}{VSURF_interp}(x, var.names = FALSE,
  nvar.interp = length(x$varselect.thres), ...)

\method{plot}{VSURF_pred}(x, var.names = FALSE,
  nvar.pred = length(x$varselect.pred), ...)
}
\arguments{
\item{x}{An object of class \code{VSURF}, \code{VSURF_thres},
\code{VSURF_interp} or \code{VSURF_pred}, which is the result of the
\code{\link{VSURF}} function (or resp. \code{\link{VSURF_thres}},
\code{\link{VSURF_interp}} or \code{\link{VSURF_pred}}).}

\item{step}{A character string indicating which step must be plotted (default is "all").
Available choices are "thres", "interp", "pred".}

\item{var.names}{If FALSE (default) xticks are the numbering given by the
sorting of VI mean, if TRUE they are the variables names.}

\item{imp.mean}{If TRUE (default) VI mean is plotted, if FALSE it is not.}

\item{imp.sd}{If TRUE (default) VI standard deviation is plotted, if FALSE
it is not.}

\item{nvar.imp.mean}{The number of variables to be kept for the VI mean plot.}

\item{nvar.imp.sd}{The number of variables to be kept for the VI standard
deviation plot.}

\item{nvar.interp}{The number of variables to be kept for the "interp" plot.}

\item{nvar.pred}{The number of variables to be kept for the "pred" plot.}

\item{\dots}{Arguments to be passed to \code{\link{par}} (they will affect
all plots) or to others methods of plot.}
}
\description{
This function plots 4 graphs illustrating VSURF results.
}
\details{
The 2 graphs of the top row correspond to the "thresholding step" (and only
these 2 graphs are plotted by the \code{plot.VSURF_thres} function).  The
top left graph plots the mean variable importance in decreasing order (black
curve). The red horizontal line represent the value of the threshold.  The
top right graph plots the standard deviation of variable importance with
variables ordered according to their mean variable importance in decreasing
order (black curve). The green line represents the predictions given by a
CART tree fitted to the black curve (the standard deviations). Finally, the
dotted horizontal red line represents the minimum value of the CART
predictions, which actually is the value of the threshold.

The bottom left graph corresponds to the "interpretation step" (and only
this graph is plotted by the \code{plot.VSURF_interp} function). It plots
the mean OOB error rate of embedded random forests models (from the one with
only one variable as predictor, to the one with all variables kept after the
"thresholding step"). The vertical red line indicates the retained model.

The bottom right graph corresponds to the "predicton step" (and only this
graph is plotted by the \code{plot.VSURF_pred} function). It plots the mean
OOB error rate of embedded random forests models (the difference, here,
being that variables are added to the model in a step-wise manner). The
retained model is the final one.
}
\examples{
\dontrun{
data(iris)
iris.vsurf <- VSURF(iris[,1:4], iris[,5])
plot(iris.vsurf)
plot(iris.vsurf, var.names=TRUE)
plot(iris.vsurf, step="thres")

# A more interesting example with toys data (see \\code{\\link{toys}})
# (a few minutes to execute) and intermediate functions
data(toys)
toys.vsurf <- VSURF(toys$x, toys$y)
plot(toys.vsurf)
plot(toys.vsurf, nvar.imp.mean = 50, nvar.imp.sd = 50)
toys.thres <- VSURF_thres(toys$x, toys$y)
plot(toys.thres)
plot(toys.thres, nvar.imp.mean = 70, imp.sd = FALSE)
toys.interp <- VSURF_interp(toys$x, toys$y, vars = toys.thres$varselect.thres)
plot(toys.interp, var.names = TRUE)
toys.pred <- VSURF_pred(toys$x, toys$y, err.interp = toys.interp$err.interp,
                        varselect.interp = toys.interp$varselect.interp)
plot(toys.pred, var.names = TRUE)
}
}
\author{
Robin Genuer, Jean-Michel Poggi and Christine Tuleau-Malot
}
\references{
Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2010),
\emph{Variable selection using random forests}, Pattern Recognition Letters
31(14), 2225-2236
}
\seealso{
\code{\link{VSURF}}, \code{\link{summary.VSURF}}
}

