% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_LpS.R
\name{second.step.detect}
\alias{second.step.detect}
\title{Backward elimination algorithm for screening in the second step}
\usage{
second.step.detect(
  data,
  pts,
  omega,
  lambda,
  mu,
  alpha_L = 0.25,
  verbose = FALSE
)
}
\arguments{
\item{data}{a n by p dataset matrix}

\item{pts}{a vector includes all candidate change points obtained by the first step}

\item{omega}{tuning parameter for the information criterion function}

\item{lambda}{tuning parameter for sparse component estimation}

\item{mu}{tuning parameter for low rank component estimation}

\item{alpha_L}{a numeric value, indicates the size of constraint space of low rank component}

\item{verbose}{if TRUE, then it provides all information for current stage}
}
\value{
A list object includes
\describe{
    \item{pts}{Final selected change points}
    \item{ic}{Values of information criterion}
}
}
\description{
Backward elimination algorithm function for screening
}
\keyword{internal}
