% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_LpS.R
\name{detect.LpS}
\alias{detect.LpS}
\title{Single change point detection for low-rank plus sparse model structure}
\usage{
detect.LpS(data, lambda, mu, alpha_L, skip = 50)
}
\arguments{
\item{data}{A n by p dataset, n is the number of observations, p is the number of variables}

\item{lambda}{A 2-d vector recording tuning parameters for sparse components left/right}

\item{mu}{A 2-d vector recording tuning parameters for low rank components left/right}

\item{alpha_L}{A numeric value, a positive number indicating the constraint space for low rank matrix}

\item{skip}{The number of observations at the boundaries we should skip}
}
\value{
A list object, which includes the followings:
\describe{
  \item{cp}{A vector recording all estimated change points}
  \item{S_hat1}{Estimated sparse component for the left-handed side}
  \item{S_hat2}{Estimated sparse component for the right-handed side}
  \item{L_hat1}{Estimated low rank component for the left-handed side}
  \item{L_hat2}{Estimated low rank component for the right-handed side}
  \item{sse}{The sum of squared errors for all passed time points}
}
}
\description{
Single change point detection for low-rank plus sparse model using minimizing SSE method.
}
