% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_VALERIE_ComputePSI.R
\name{ComputePSI}
\alias{ComputePSI}
\title{Percent spliced-in (PSI) computation}
\usage{
ComputePSI(SampleInfo, ExonInfo, BAM, MinCoverage)
}
\arguments{
\item{SampleInfo}{Tab-delimited file describing the naming and grouping of the single cells. First column should contain the names of the binary alignment map (BAM) files. Second column indicates the grouping for each single cell, namely Group1 and Group2. Third column indicates the group names. Example file provided in extdata directory of the package.}

\item{ExonInfo}{Tab-delimited file describing the alternative splicing events. First columns contains the alternative splicing nomenclature as per BRIE (Huang et al, Genome Biology, 2018) or MISO (Katz et al, Nature Methods, 2010). Second column indicates the type of alternative splicing event, namely SE, MXE, RI, A5SS, and A3SS. Third column contains the gene name or any personal notation. Example file provided in extdata directory of the package.}

\item{BAM}{Folder containing the BAM files sorted by genomic coordinates.}

\item{MinCoverage}{numeric. Coverage (Total reads) threshold below which the PSI value of the genomic coordinate is annotate as missing value, i.e. no coverage.}
}
\value{
A data frame of class rehab where rows are the genomic coordinates and columns are the sample names.
}
\description{
\code{ComputePSI} computes percent spliced-in (PSI) at each genomic coordinate for exon-level alternative splicing events, namely skipped exon (SE), mutually exclusive exons (MXE), retained intron (RI), alternative 5' splice site (A5SS), and alternative 3' splice site (A3SS)
}
\details{
This function computes the percent spliced-in (PSI) at each genomic coordinate encompassing the alternative exon and its flanking constitutive exons. Formula for computing PSI is number of reads with non-N CIGAR operation divided by the total number of reads. Total number of reads is the sum of reads with non-N CIGAR operation and reads with N-CIGAR operation
}
\examples{
PSI <- ComputePSI(SampleInfo=system.file("extdata/Sample_Info",
  "Sample_Info_small.txt", package="VALERIE"),
  ExonInfo=system.file("extdata/Exon_Info", "Exon_Info.txt", package="VALERIE"),
  BAM=system.file("extdata/BAM", "", package="VALERIE"),
  MinCoverage=10)
PSI[1:5,1:4]
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
