% Generated by roxygen2 (4.0.2): do not edit by hand
\name{outerLoop}
\alias{outerLoop}
\title{UPMASK outer loop}
\usage{
outerLoop(ocdata_full, positionDataIndexes=c(1,2),
photometricDataIndexes=c(3,5,7,9,11,19,21,23,25,27),
photometricErrorDataIndexes=c(4,6,8,10,12,20,22,24,26,28), threshold=1, maxIter=25,
plotIter=FALSE, verbose=FALSE, starsPerClust_kmeans=50, nstarts_kmeans=50,
finalXYCut=FALSE, autoCalibrated=FALSE, considerErrors=FALSE, run=0, smartTableDB)
}
\arguments{
\item{ocdata_full}{a data frame with the data to perform the analysis}

\item{positionDataIndexes}{an array of integers indicating the columns of the data frame containing the spatial position measurements}

\item{photometricDataIndexes}{an array of integers with the column numbers containing photometric measurements (or any other measurement to go into the PCA step)}

\item{photometricErrorDataIndexes}{an array of integers with the column numbers containing the errors of the photometric measurements}

\item{threshold}{a double indicating the thresholding level for the random field analysis}

\item{maxIter}{an integer the maximum amount of iterations of the outer loop before giving up convergence (usually it is not necessary to modify this)}

\item{plotIter}{a boolean indicating if the user wants to see iteration plots}

\item{verbose}{a boolean indicating if the output to screen should be verbose}

\item{starsPerClust_kmeans}{an integer with the average number of stars per k-means cluster}

\item{nstarts_kmeans}{an integer the amount of random re-initializations of the k-means clustering method (usually it is not necessary to modify this)}

\item{finalXYCut}{a boolean indicating if a final cut in the XY space should be performed (defaults to FALSE)}

\item{autoCalibrated}{a boolean indicating if the number of random field realizations for the clustering check in the position space should be autocalibrated (experimental code, defaults to FALSE).}

\item{considerErrors}{a boolean indicating if the errors should be taken into account}

\item{run}{an integer greater than zero indicating the run number}

\item{smartTableDB}{a database connection to the smart look-up table}
}
\value{
A data frame with the id and class (member / not member) of each object at this run.
}
\description{
\code{outerLoop} executes the UPMASK method's outer loop on a data frame,
and returns another data frame as output, with the id of the object and it's
classification as a stellar cluster member or not.

The \code{outerLoop} perform cuts in the data if necessary (by calling
\code{\link{performCuts}}), take errors in the data table into account if the user request (by
calling \code{\link{innerLoop}}), runs the inner loop (by calling \code{\link{innerLoop}}) until
convergence of the membership list or util the maximum number of iterations is reached.
}
\examples{
\dontrun{
# Perform a one run of the outerLoop using a simulated open cluster with
# spatial and photometric data
# Load the data into a data frame
fileName <- "oc_12_500_1000_1.0_p019_0880_1_25km_120nR_withcolors.dat"
inputFileName <- system.file("extdata", fileName, package="UPMASK")
ocData <- read.table(inputFileName, header=TRUE)

# Create the look up table
library(RSQLite)
stcon <- create_smartTable()

# Run the outer loop
posIdx <- c(1,2)
photIdx <- c(3,5,7,9,11,19,21,23,25,27)
photErrIdx <- c(4,6,8,10,12,20,22,24,26,28)
outerLoopRes <- outerLoop(ocData, posIdx, photIdx, PhotErrIdx,
                          starsPerClust_kmeans=25, verbose=TRUE, smartTableDB=stcon)

# Clean the environment
rm(list=c("inputFileName", "ocData", "posIdx", "photIdx", "photErrIdx",
          "outerLoopRes", "fileName"))
dbDisconnect(stcon)
}
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\references{
\href{http://dx.doi.org/10.1051/0004-6361/201321143}{Krone-Martins, A. & Moitinho, A., A&A, v.561, p.A57, 2014}
}
\keyword{cluster,}
\keyword{methods,}
\keyword{multivariate,}
\keyword{nonparametric}

