% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GumbelPars}
\alias{GumbelPars}
\title{Gumbel distribution parameter estimates}
\usage{
GumbelPars(x = NULL, mle = FALSE, L1, LCV)
}
\arguments{
\item{x}{numeric vector. The sample}

\item{mle}{logical argument with a default of FALSE. If FALSE the parameters are estimated with Lmoments, if TRUE the parameters are estimated by maximum likelihood estimation}

\item{L1}{first Lmoment}

\item{LCV}{linear coefficient of variation}
}
\value{
Parameter estimates (location, scale)
}
\description{
Estimated parameters from a sample (with Lmoments or maximum likelihood estimation) or from L1 (first L-moment), Lcv (linear coefficient of variation)
}
\details{
The L-moment estimated parameters are by the method detailed in 'Hosking J. Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-moments. Cambridge University Press, New York'
}
\examples{
#Get an annual maximum sample and estimate the parameters using Lmoments
AM.27090 <- GetAM(27090)
GumbelPars(AM.27090$Flow)
#Estimate parameters using MLE
GumbelPars(AM.27090$Flow, mle = TRUE)
#calculate Lmoments and estimate the parmeters with L1 and Lcv
Pars <- as.numeric(Lmoms(AM.27090$Flow)[c(1,5)])
GumbelPars(L1 = Pars[1], LCV = Pars[2])
}
\author{
Anthony Hammond
}
