% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_general.R
\name{query_general_value}
\alias{query_general_value}
\title{download data for shiny general analysis}
\usage{
query_general_value(
  L1,
  L2,
  L3,
  database = c("toil", "pcawg", "ccle"),
  index_value,
  immune_value,
  pathway_value,
  clinical_value,
  opt_pancan = NULL,
  custom_metadata = NULL
)
}
\arguments{
\item{L1}{level 1  main datatype}

\item{L2}{level 2  sub datatype}

\item{L3}{level 3  identifier}

\item{database}{one of c("toil","pcawg","ccle")}

\item{index_value}{tumor index list}

\item{immune_value}{tumor immune infiltration list}

\item{pathway_value}{pathway activity list}

\item{clinical_value}{clinical data.frame}

\item{opt_pancan}{molecular datasets parameters}

\item{custom_metadata}{user customized metadata}
}
\description{
download data for shiny general analysis
}
\examples{
\dontrun{
general_value_id = UCSCXenaShiny:::query_general_id()
tcga_value_option = general_value_id[["value"]][[1]]
tcga_index_value = tcga_value_option[["Tumor index"]]
tcga_immune_value = tcga_value_option[["Immune Infiltration"]]
tcga_pathway_value = tcga_value_option[["Pathway activity"]]
tcga_phenotype_value = tcga_value_option[["Phenotype data"]]
clinical_phe = tcga_phenotype_value[["Clinical Phenotype"]]
x_data = UCSCXenaShiny:::query_general_value(
           "Molecular profile", "mRNA Expression", "TP53", "toil",
           tcga_index_value, tcga_immune_value, tcga_pathway_value, 
           clinical_phe)
                                             
y_data = UCSCXenaShiny:::query_general_value(
           "Immune Infiltration", "CIBERSORT", "Monocyte", "toil",
           tcga_index_value, tcga_immune_value, tcga_pathway_value, 
           clinical_phe)
}
}
