"plot.OneWaySurvfit" <-
function(x,...)
{
factor.names<-x$factor.names
grid.frame<-x$grid.frame
varying.frame<-x$varying.frame
deviation.frame<-x$deviation.frame
p<-x$p

attach(varying.frame);attach(deviation.frame)


las<-1;cex.main<-0.9;tcl<- -0.1;cex.lab<-0.7;cex.axis<-0.7;lwd<-1


y.range.t.baseline<-range(c(varying.frame$alpha.t.Baseline-deviation.frame$deviation.t.Baseline,varying.frame$alpha.t.Baseline+deviation.frame$deviation.t.Baseline))

plot(grid.frame$grid.t,varying.frame$alpha.t.Baseline,xlab="Duration time (t)",ylab="",cex=0.1,main="Baseline",ylim=y.range.t.baseline,...)
vector.minus<-varying.frame$alpha.t.Baseline-deviation.frame$deviation.t.Baseline
vector.plus<-varying.frame$alpha.t.Baseline+deviation.frame$deviation.t.Baseline
polygon(cbind(c(grid.frame$grid.t,grid.frame$grid.t[length(grid.frame$grid.t):1]),c(vector.minus,vector.plus[length(vector.plus):1])),col="grey")
lines(grid.frame$grid.t,varying.frame$alpha.t.Baseline,lwd=lwd)
lines(grid.frame$grid.t,varying.frame$alpha.t.Baseline-deviation.frame$deviation.t.Baseline,cex=0.08,col=3)
lines(grid.frame$grid.t,varying.frame$alpha.t.Baseline+deviation.frame$deviation.t.Baseline,cex=0.08,col=3)
abline(h=0,lty=3,cex=0.05)
par(new=TRUE)
plot(grid.frame$grid.t,varying.frame$alpha.t.Baseline,type="n",xlab="",ylab="",bty="o",xaxt="n",yaxt="n",...)



if (dim(x$varying.frame)[2] > 1)
  {
#ranges for y in plots
y.range.t<-range(c(unlist(mget(paste("alpha.t.",factor.names[1:length(factor.names)],sep=""),envir=as.environment("varying.frame")))-unlist(mget(paste("deviation.t.",factor.names[1:length(factor.names)],sep=""),envir=as.environment("deviation.frame"))),unlist(mget(paste("alpha.t.",factor.names[1:length(factor.names)],sep=""),envir=as.environment("varying.frame")))+unlist(mget(paste("deviation.t.",factor.names[1:length(factor.names)],sep=""),envir=as.environment("deviation.frame")))))

y.range<-range(y.range.t)  
    
  
for (k in 1:p)
{
plot(grid.frame$grid.t,get(paste("alpha.t.",factor.names[k],sep=""),pos="varying.frame"),xlab="Duration time (t)",ylab="",cex=0.1,main=factor.names[k],ylim=y.range,...)
vector.minus<-get(paste("alpha.t.",factor.names[k],sep=""),pos="varying.frame")-get(paste("deviation.t.",factor.names[k],sep=""),pos="deviation.frame")
vector.plus<-get(paste("alpha.t.",factor.names[k],sep=""),pos="varying.frame")+get(paste("deviation.t.",factor.names[k],sep=""),pos="deviation.frame")
polygon(cbind(c(grid.frame$grid.t,grid.frame$grid.t[length(grid.frame$grid.t):1]),c(vector.minus,vector.plus[length(vector.plus):1])),col="grey")
lines(grid.frame$grid.t,get(paste("alpha.t.",factor.names[k],sep=""),pos="varying.frame"),lwd=lwd)
lines(grid.frame$grid.t,get(paste("alpha.t.",factor.names[k],sep=""),pos="varying.frame")-get(paste("deviation.t.",factor.names[k],sep=""),pos="deviation.frame"),cex=0.08,col=3)
lines(grid.frame$grid.t,get(paste("alpha.t.",factor.names[k],sep=""),pos="varying.frame")+get(paste("deviation.t.",factor.names[k],sep=""),pos="deviation.frame"),cex=0.08,col=3)
abline(h=0,lty=3,cex=0.05)
par(new=TRUE)
plot(grid.frame$grid.t,alpha.t.Baseline,type="n",xlab="",ylab="",bty="o",xaxt="n",yaxt="n",...)
}
}

detach(varying.frame);detach(deviation.frame)

}

