% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.R
\name{turtle_do}
\alias{turtle_do}
\title{Evaluate a Larger Portion of Turtle Drawing Code}
\usage{
turtle_do(expr)
}
\arguments{
\item{expr}{expression to evaluate}
}
\description{
\code{turtle_do} evaluates an R expression
with the Turtle temporarily hidden (for performance reasons).
}
\details{
The terrarium must be initialized prior to using
these functions, see \code{\link{turtle_init}}.

In order to decrease the evaluation time of \code{expr},
it is evaluated with Turtle temporarily hidden.
Basically it means that if a Turtle image is visible (see
\code{\link{turtle_show}} and \code{\link{turtle_hide}}) \code{turtle_do}
removes it, evaluates \code{expr} and redraws it on the function exit.
}
\examples{
turtle_init()
turtle_do({
   for (i in 1:4) {
      turtle_forward(50)
      turtle_right(90)
   }
})

}
\seealso{
Other TurtleGraphics: \code{\link{TurtleGraphics-package}},
  \code{\link{turtle_getpos}}, \code{\link{turtle_goto}},
  \code{\link{turtle_init}}, \code{\link{turtle_move}},
  \code{\link{turtle_param}}, \code{\link{turtle_reset}},
  \code{\link{turtle_show}}, \code{\link{turtle_status}},
  \code{\link{turtle_turn}}, \code{\link{turtle_up}}
}
