% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathLengths.R
\name{PathLengths}
\alias{PathLengths}
\title{Calculate length of paths between each pair of vertices within tree}
\usage{
PathLengths(tree, fullMatrix = FALSE, use.na = TRUE)
}
\arguments{
\item{tree}{Original tree of class \code{phylo}, in \code{\link{Preorder}}.}

\item{fullMatrix}{Logical specifying return format; see "value" section`.}

\item{use.na}{Logical specifying whether to set non-existent paths to \code{NA},
or to leave uninitialized.  Set to \code{FALSE} to maximize performance.}
}
\value{
If \code{fullMatrix = TRUE}, \code{PathLengths()} returns a square matrix in
which entry \verb{[i, j]} denotes the distance from internal node \code{i} to the
descendant vertex \code{j}.
Vertex pairs without a continuous directed path are denoted \code{NA} if \code{use.na}
is \code{TRUE}.
If \code{fullMatrix = FALSE}, \code{PathLengths()} returns a \code{data.frame} with three
columns: \code{start} lists the deepest node in each path (i.e. that closest
to the root); \code{end} lists the shallowest node (i.e. that closest to a leaf);
\code{length} lists the total length of that path.
}
\description{
Given a weighted rooted tree \code{tree}, \code{PathLengths()} returns the distance
from each vertex to each of its descendant vertices.
}
\examples{
tree <- rtree(6)
plot(tree)
add.scale.bar()
nodelabels()
tiplabels()
PathLengths(tree)
}
\seealso{
Other tree properties: 
\code{\link{ConsensusWithout}()},
\code{\link{LongBranch}()},
\code{\link{MatchEdges}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{NodeNumbers}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()},
\code{\link{Treeness}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree properties}
