% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatchNodes.R
\name{MatchEdges}
\alias{MatchEdges}
\alias{MatchNodes}
\title{Match nodes and edges between trees}
\usage{
MatchEdges(x, table, nomatch = NA_integer_)

MatchNodes(x, table, nomatch = NA_integer_, tips = FALSE)
}
\arguments{
\item{x}{Tree whose nodes are to be matched.}

\item{table}{Tree containing nodes to be matched against.}

\item{nomatch}{Integer value that will be used in place of \code{NA} in the case
where no match is found.}

\item{tips}{Logical specifying whether to return matches for tips;
unless \code{TRUE}, only the matches for internal nodes will be returned.}
}
\description{
\code{MatchNodes()} and \code{MatchEdges()} matches nodes or edges in one tree to
entries in the second that denote a clade with identical tip labels.
}
\details{
The current implementation is potentially inefficient.
Please contact the maintainer to request a more efficient implementation if
this function is proving a bottleneck.
}
\examples{
MatchNodes(BalancedTree(8), RootTree(BalancedTree(8)))
}
\seealso{
Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}

Other tree properties: 
\code{\link{ConsensusWithout}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{NodeNumbers}()},
\code{\link{PathLengths}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree navigation}
\concept{tree properties}
