% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Concordance.R
\name{SiteConcordance}
\alias{SiteConcordance}
\alias{QuartetConcordance}
\alias{ClusteringConcordance}
\alias{PhylogeneticConcordance}
\alias{MutualClusteringConcordance}
\alias{SharedPhylogeneticConcordance}
\title{Calculate site concordance factor}
\usage{
QuartetConcordance(tree, dataset = NULL, weight = TRUE)

ClusteringConcordance(tree, dataset)

PhylogeneticConcordance(tree, dataset)

MutualClusteringConcordance(tree, dataset)

SharedPhylogeneticConcordance(tree, dataset)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.
Perhaps load into R using \code{\link[TreeTools]{ReadAsPhyDat}}.
Additive (ordered) characters can be handled using
\code{\link[TreeTools]{Decompose}}.}

\item{weight}{Logical specifying whether to weight sites according to the
number of quartets they are decisive for.}
}
\description{
The site concordance factor \insertCite{Minh2020}{TreeSearch} is a measure
of the strength of support that the dataset presents for a given split in a
tree.
}
\details{
\code{QuartetConcordance()} is the proportion of quartets (sets of four leaves)
that are decisive for a split which are also concordant with it.
For example, a quartet with the characters \verb{0 0 0 1} is not decisive, as
all relationships between those leaves are equally parsimonious.
But a quartet with characters \verb{0 0 1 1} is decisive, and is concordant
with any tree that groups the first two leaves together to the exclusion
of the second.

By default, the reported value weights each site by the number of quartets
it is decisive for.  This value can be interpreted as the proportion of
all decisive quartets that are concordant with a split.
If \code{weight = FALSE}, the reported value is the mean of the concordance
value for each site.
Consider a split associated with two sites:
one that is concordant with 25\% of 96 decisive quartets, and
a second that is concordant with 75\% of 4 decisive quartets.
If \code{weight = TRUE}, the split concordance will be 24 + 3 / 96 + 4 = 27\%.
If \code{weight = FALSE}, the split concordance will be mean(75\%, 25\%) = 50\%.

\code{QuartetConcordance()} is computed exactly, using all quartets, where as
other implementations (e.g. IQ-TREE) follow
\insertCite{@Minh2020;textual}{TreeSearch} in using a random subsample
of quartets for a faster, if potentially less accurate, computation.

\strong{NOTE:} These functions are under development. They are incompletely
tested, and may change without notice.
Complete documentation and discussion will follow in due course.
}
\examples{
data("congreveLamsdellMatrices", package = "TreeSearch")
dataset <- congreveLamsdellMatrices[[1]][, 1:20]
tree <- referenceTree
qc <- QuartetConcordance(tree, dataset)
cc <- ClusteringConcordance(tree, dataset)
pc <- PhylogeneticConcordance(tree, dataset)
spc <- SharedPhylogeneticConcordance(tree, dataset)
mcc <- MutualClusteringConcordance(tree, dataset)

oPar <- par(mar = rep(0, 4), cex = 0.8) # Set plotting parameters
plot(tree)
TreeTools::LabelSplits(tree, signif(qc, 3), cex = 0.8)
plot(tree)
TreeTools::LabelSplits(tree, signif(cc, 3), cex = 0.8)
par(oPar) # Restore plotting parameters

# Write concordance factors to file
labels <- paste0(qc, "/", cc, "/", pc) # "/" is a valid delimiter
# Identify the node that corresponds to each label
whichNode <- match(TreeTools::NTip(tree) + 1:tree$Nnode, names(qc))

# The contents of tree$node.label will be written at each node
tree$node.label <- labels[whichNode]

ape::write.tree(tree) # or write.nexus(tree, file = "mytree.nex")

# Display correlation between concordance factors
pairs(cbind(qc, cc, pc, spc, mcc), asp = 1)
}
\references{
\insertAllCited{}
}
\seealso{
Other split support functions: 
\code{\link{JackLabels}()},
\code{\link{Jackknife}()},
\code{\link{MaximizeParsimony}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split support functions}
