context("Profile Parsimony: Tree scoring")
test_that("Profile score calculated correctly", {
  data(referenceTree)
  data(congreveLamsdellMatrices)
  tree <- referenceTree
  set.seed(0)
  dataset <- PrepareDataProfile(congreveLamsdellMatrices[[1]], 4e+04, warn=FALSE)
  expect_equal(Fitch(tree, dataset), sum(FitchSteps(tree, dataset) * attr(dataset, 'weight')))
  score <- ProfileScore(tree, dataset)
  expect_true(abs(354.58 + score) < 9) # Range as concavity constants generated by approximation
})
