% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_spr.R
\name{SPRDist}
\alias{SPRDist}
\title{Approximate Subtree Prune and Regraft distance}
\usage{
SPRDist(tree1, tree2 = NULL, symmetric = TRUE)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on Day (1985).}

\item{symmetric}{Logical specifying whether to produce a better heuristic
by calculating the minimum of \code{SPRDist(t1, t2)} and \code{SPRDist(t2, t1)},
which are not guaranteed to be equal due to the heuristic nature of the
approximation (see
\href{https://github.com/KlausVigo/phangorn/issues/97}{phangorn#97}). Set to
\code{FALSE} for the faster approximation, as implemented in "phangorn".}
}
\value{
\code{SPRDist()} returns a vector or distance matrix of distances
between trees.
}
\description{
Approximate the Subtree Prune and Regraft (SPR) distance.
}
\details{
\code{SPRDist()} is a wrapper for the function
\code{\link[phangorn:treedist]{SPR.dist()}} in the phangorn package.
It pre-processes trees to ensure that their internal representation does
not cause the \code{SPR.dist()} function to crash R, and allows an improved
(but slower) symmetric heuristic.

A memory leak is present in phangorn v2.5.5.  To avoid a drain on system
resources, install the latest version of phangorn with
\code{devtools::install_github("KlausVigo/phangorn")}.
}
\examples{
library("TreeTools", quietly = TRUE)

SPRDist(BalancedTree(7), PectinateTree(7))

SPRDist(BalancedTree(7), as.phylo(0:2, 7))
SPRDist(as.phylo(0:2, 7), PectinateTree(7))

SPRDist(list(bal = BalancedTree(7), pec = PectinateTree(7)),
        as.phylo(0:2, 7))

CompareAll(as.phylo(30:33, 8), SPRDist)
}
\seealso{
Other tree distances: 
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NNIDist}()},
\code{\link{NyeSimilarity}()},
\code{\link{PathDist}()},
\code{\link{Robinson-Foulds}},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
