% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorPredictive.R
\name{priorPredictive}
\alias{priorPredictive}
\title{Prior Predictive Samples}
\usage{
priorPredictive(
  prior,
  eqnfile,
  restrictions,
  numItems,
  level = "data",
  N = 1,
  M = 100,
  nCPU = 4
)
}
\arguments{
\item{prior}{a named list defining the priors. For the \link{traitMPT}, the
default is \code{list(mu = "dnorm(0,1)", xi="dunif(0,10)", V=diag(S),
df=S+1)}, where S is the number of free parameters. For the \link{betaMPT},
the default is \code{list(alpha ="dgamma(1,.1)", beta = "dgamma(1,.1)")}.
Note that the normal distribution \code{"dnorm(mu,prec)"} is parameterized
as in JAGS by the mean and precision (= 1/variance).}

\item{eqnfile}{The (relative or full) path to the file that specifies the MPT
model (standard .eqn syntax). Note that category labels must start with a
letter (different to multiTree) and match the column names of \code{data}.
Alternatively, the EQN-equations can be provided within R as a character
value (cf. \code{\link{readEQN}}). Note that the first line of an .eqn-file
is reserved for comments and always ignored.}

\item{restrictions}{Specifies which parameters should be (a) constant (e.g.,
\code{"a=b=.5"}) or (b) constrained to be identical (e.g., \code{"Do=Dn"})
or (c) treated as fixed effects (i.e., identical for all participants;
\code{"a=b=FE"}). Either given as the path to a text file with restrictions
per row or as a list of restrictions, e.g., \code{list("D1=D2","g=0.5")}.
Note that numbers in .eqn-equations (e.g., \code{d*(1-g)*.50}) are directly
interpreted as equality constraints.}

\item{numItems}{vector with the number of items per MPT tree (either named or
assigned to alphabetically ordered tree labels)}

\item{level}{either \code{"data"} (returns individual frequencies) or
\code{"parameter"} (returns group-level MPT parameters; \code{M} and
\code{numItems} are ignored)}

\item{N}{number of participants per replication}

\item{M}{number of prior predictive samples (i.e., data sets with \code{N}
participants).}

\item{nCPU}{number of CPUs used for parallel sampling. For large models and
many participants, this may require a lot of memory.}
}
\value{
a list of \code{M} matrices with individual frequencies
  (rows=participants, columns=MPT categories). A single matrix is returned if
  \code{M=1} or \code{level="parameter"}.
}
\description{
Samples full data sets (i.e., individual response frequencies) or group-level
MPT parameters based on prior distribution for group-level parameters.
}
\examples{
eqnfile <- system.file("MPTmodels/2htm.eqn",
  package = "TreeBUGS"
)
### beta-MPT:
prior <- list(
  alpha = "dgamma(1,.1)",
  beta = "dgamma(1,.1)"
)

### prior-predictive frequencies:
priorPredictive(prior, eqnfile,
  restrictions = list("g=.5", "Do=Dn"),
  numItems = c(50, 50), N = 10, M = 1, nCPU = 1
)

### prior samples of group-level parameters:
priorPredictive(prior, eqnfile,
  level = "parameter",
  restrictions = list("g=.5", "Do=Dn"),
  M = 5, nCPU = 1
)

### latent-trait MPT
priorPredictive(
  prior = list(
    mu = "dnorm(0,1)", xi = "dunif(0,10)",
    df = 3, V = diag(2)
  ),
  eqnfile, restrictions = list("g=.5"),
  numItems = c(50, 50), N = 10, M = 1, nCPU = 1
)

}
