% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDataTrait.R
\name{genTraitMPT}
\alias{genTraitMPT}
\title{Generate Data for Trait MPT Models}
\usage{
genTraitMPT(N, numItems, eqnfile, mean = NULL, sigma = NULL, rho = NULL)
}
\arguments{
\item{N}{number of participants}

\item{numItems}{number of responses per tree (a named vector with tree labels)}

\item{eqnfile}{path to EQN file specifying the MPT model}

\item{mean}{Named vector of true group means of individual MPT parameters (probabilities in the interval [0,1]). If the vector is not named, the internal order of parameters is used (can be obtained using \code{\link{readEQN}}).}

\item{sigma}{(named) vector of group standard deviations of latent (!) individual MPT parameters. Default is zero (no person heterogeneity).}

\item{rho}{(named) correlation matrix for latent (!) individual MPT parameters. Must be symmetric and positive definite (e.g., no correlations of 1 or -1 allowed). Default: a diagonal matrix (i.e., zero correlations)

Data are generated independently from the JAGS model files used for fitting the Trait-MPT model. If data for an equality-constrained version of the MPT model are required, the restrictions need to be hard-coded into the EQN-model file. Note that equal means still result in nonidentical MPT parameters on the individual level!}
}
\value{
a list including the generated frequencies (\code{data}) and the true, underlying parameters (\code{parameters})
}
\description{
Generating a data file with known parameter structure using the Trait-MPT. Useful for simulations and robustness checks.
}
\examples{
# Example: Standard Two-High-Threshold Model (2HTM)
EQNfile <- paste0(.libPaths()[1], "/TreeBUGS/MPTmodels/2htm.eqn")
genDat <- genTraitMPT(N = 100,
                      numItems = c(Target=250, Lure=250),
                      eqnfile = EQNfile,
                      mean = c(Do=.7, Dn=.7, g=.5),
                      sigma =   c(Do=.3, Dn=.3, g=.15),
                      rho = matrix(c(1 , .8, .2,
                                     .8, 1 , .1,
                                     .2, .1, 1 ),
                                   nrow=3))

}
\references{
Klauer, K. C. (2010). Hierarchical multinomial processing tree models: A latent-trait approach. Psychometrika, 75, 70-98.
}
\seealso{
\code{\link{genMPT}}
}

